package w83b.w83bDAO;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import w83b.util.jdbc.W83bDataBase;
import w83b.w83bBeans.W83bComunicacionesBean;
import w83b.w83bBeans.W83bDocBean;
import w83b.w83bBeans.W83bSindicatosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bDAO.w83bConstantesBD.W83bActasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bComunicacionesBD;
import w83b.w83bDAO.w83bConstantesBD.W83bImpugnacionesBD;
import w83b.w83bDAO.w83bConstantesBD.W83bImpugnacionesSindicatosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bIncidenciasHistorialBD;
import w83b.w83bDAO.w83bConstantesBD.W83bListadosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bMigracionBD;
import w83b.w83bDAO.w83bConstantesBD.W83bPreavisosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bRespAreaBD;
import w83b.w83bDAO.w83bConstantesBD.W83bSindicatosBD;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import w83b.w83bUtilidadesComunes.W83bUtilidades;


public class W83bComunicacionesDAO implements W83bIComunicacionesDAO {
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bComunicacionesDAO#generarComunicPreaviso(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List generarComunicPreaviso(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT "); 
		strSql.append("TO_CHAR(").append(W83bComunicacionesBD.fechaentrada).append(",?) AS ").append(W83bListadosBD.fechaEntrada).append(" , ");
		strSql.append(W83bComunicacionesBD.numpreaviso).append(", ");
		strSql.append(W83bComunicacionesBD.numpreavisoint).append(", ");
		strSql.append(W83bComunicacionesBD.razon).append(", ");
		strSql.append(W83bComunicacionesBD.domicilio).append(", ");
		strSql.append(W83bComunicacionesBD.codigopostal).append(", ");
		strSql.append(W83bComunicacionesBD.municipio).append(", ");
		strSql.append(W83bComunicacionesBD.provincia).append(", ");
		strSql.append(W83bComunicacionesBD.territ).append(", ");
		strSql.append(W83bComunicacionesBD.anopreaviso).append(", ");
		strSql.append(W83bComunicacionesBD.npre).append(", ");
		strSql.append(W83bComunicacionesBD.dirorig).append(", ");
		strSql.append(W83bComunicacionesBD.cporig).append(", ");
		strSql.append(W83bComunicacionesBD.munorig).append(", ");
		strSql.append(W83bComunicacionesBD.provorig);
		strSql.append(" FROM ").append(W83bComunicacionesBD.vistacomunicpreaviso);
		strSql.append(" WHERE ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		if(StringUtils.isNotEmpty(param.getFechapreavisodesde())){
			strSql.append(W83bComunicacionesBD.fechaentrada).append(">=").append("TO_DATE(?,?)");
			params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechapreavisodesde(),param.getIdioma()), param.getIdioma()));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		strSql.append(" AND ");
		strSql.append("((").append(W83bComunicacionesBD.anopreaviso).append("=").append("?");
		params.add(new Integer(param.getAnopreaviso()));
		strSql.append(" AND ");
		strSql.append(W83bComunicacionesBD.npre).append(">=").append("?").append(")");
		params.add(param.getNumpreaviso());	
		strSql.append(" OR ");
		strSql.append("(").append(W83bComunicacionesBD.anopreaviso).append(">").append("?");
		params.add(new Integer(param.getAnopreaviso()));
		strSql.append(" AND ");
		strSql.append(W83bComunicacionesBD.npre).append(">=").append("0").append("))");
		if(StringUtils.isNotEmpty(param.getTerritorio())){
			strSql.append(" AND ");
			strSql.append(W83bListadosBD.territorio).append("=").append("?");
			params.add(param.getTerritorio());
		}
		
		List lista=W83bDataBase.executeQuery(strSql.toString(),params,W83bComunicacionesBean.class,param.getUsuarioBean(), null);
		lista.add("preaviso");
		return lista;
	}
	
	public java.util.List generarComunicIncidencias(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bComunicacionesBD.nacta).append(", ");
		strSql.append(W83bComunicacionesBD.anoacta).append(", ");
		strSql.append(W83bComunicacionesBD.territ).append(", ");
		strSql.append(W83bComunicacionesBD.razon).append(", ");
		strSql.append(W83bComunicacionesBD.domicilio).append(", ");
		strSql.append(W83bComunicacionesBD.municipio).append(", ");
		strSql.append(W83bComunicacionesBD.provincia).append(", ");
		strSql.append(W83bComunicacionesBD.codigopostal).append(", ");
		strSql.append(W83bComunicacionesBD.cporig).append(", ");
		strSql.append(W83bComunicacionesBD.munorig).append(", ");
		strSql.append(W83bComunicacionesBD.provorig).append(", ");
		strSql.append(W83bComunicacionesBD.numincidencia).append(", ");
		strSql.append(W83bComunicacionesBD.anoincidencia);
		strSql.append(" FROM ");
	    strSql.append(W83bComunicacionesBD.comincidencias);
	    strSql.append(" WHERE ");
	    strSql.append(W83bComunicacionesBD.fechavalidacion).append(">=TO_DATE(?,?)");
	    strSql.append(" AND ");
	    strSql.append(W83bComunicacionesBD.fechavalidacion).append("<=TO_DATE(?,?)");
	    strSql.append(" AND ");
	    params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechavalidaciondesde(),param.getIdioma()), param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechavalidacionhasta(),param.getIdioma()), param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	    params.add(param.getTerritorio());
	    strSql.append(W83bComunicacionesBD.territ).append("=?");   
	    if (StringUtils.isNotEmpty(param.getCentroTrabajo().getNumCentro())){
	    	strSql.append(" AND ");
		    strSql.append(W83bComunicacionesBD.numcentro).append("=?");
		    params.add(param.getCentroTrabajo().getNumCentro());
	    }
	    
	    String desde = param.getAnyoactadesde();
		String hasta = param.getAnyoactahasta();
		String numDesde = param.getNumactadesde();
		String numHasta = param.getNumactahasta();
		if(StringUtils.isEmpty(param.getAnyoactadesde())){
			desde = "0000";
		}
		if(StringUtils.isEmpty(param.getAnyoactahasta())){
			hasta = "9999";
		}
		if(StringUtils.isEmpty(param.getNumactadesde())){
			numDesde = "000000";
		}else if(6>param.getNumactadesde().length()){
			for(int i = param.getNumactadesde().length(),size = 6;i<size;i++){
				numDesde = "0"+numDesde;//NOPMD
			}
		}
		if(StringUtils.isEmpty(param.getNumactahasta())){
			numHasta = "999999";
		}else if(6>param.getNumactahasta().length()){
			for(int i = param.getNumactahasta().length(),size = 6;i<size;i++){
				numHasta = "0"+numHasta;//NOPMD
			}
		}
		desde = desde + numDesde;//NOPMD
		hasta = hasta + numHasta;//NOPMD
		strSql.append(" AND SUBSTR(").append(W83bComunicacionesBD.numaactaint);
		strSql.append(" ,length(").append(W83bComunicacionesBD.numaactaint).append(")-9,10) >= ?");			
		params.add(BigDecimal.valueOf(Long.parseLong(desde)));
		strSql.append(" AND SUBSTR(").append(W83bComunicacionesBD.numaactaint);
		strSql.append(" ,length(").append(W83bComunicacionesBD.numaactaint).append(")-9,10) <= ?");	
		params.add(BigDecimal.valueOf(Long.parseLong(hasta)));
		
		
	    
	    
		List lista=W83bDataBase.executeQuery(strSql.toString(),params,W83bComunicacionesBean.class,param.getUsuarioBean(), null);
		lista.add("comincidencias");
		return lista; 
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bComunicacionesDAO#generarComunicLibroRegActas(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List generarComunicLibroRegActas(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
	
		List lista=new ArrayList();
		lista.add("1");
		return lista;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bComunicacionesDAO#generarComunicComEmpresas(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List generarComunicComEmpresas(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT "); 
		strSql.append("TO_CHAR(").append(W83bComunicacionesBD.fechaentrada).append(",?) AS ").append(W83bListadosBD.fechaEntrada).append(" , ");
		strSql.append(W83bComunicacionesBD.territ).append(", ");
		strSql.append(W83bComunicacionesBD.razon).append(", ");
		strSql.append(W83bComunicacionesBD.domicilio).append(", ");
		strSql.append(W83bComunicacionesBD.codigopostal).append(", ");
		strSql.append(W83bComunicacionesBD.municipio).append(", ");
		strSql.append(W83bComunicacionesBD.provincia).append(", ");
		strSql.append(W83bComunicacionesBD.nacta).append(", ");
		strSql.append(W83bComunicacionesBD.anoacta).append(", ");
		strSql.append(W83bComunicacionesBD.dirorig).append(", ");
		strSql.append(W83bComunicacionesBD.cporig).append(", ");
		strSql.append(W83bComunicacionesBD.munorig).append(", ");
		strSql.append(W83bComunicacionesBD.provorig);
		strSql.append(" FROM TABLE (");
	    strSql.append(W83bComunicacionesBD.comempresas);
	    //strSql.append("(?))");
	    strSql.append(")");
		strSql.append(" WHERE ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		//params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechafinimpug(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		if(StringUtils.isNotEmpty(param.getFechaentradadesde())){
			strSql.append(W83bComunicacionesBD.fechaentrada).append(">=").append("TO_DATE(?,?)");
			params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaentradadesde(),param.getIdioma()), param.getIdioma()));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getTerritorio())){
			strSql.append(" AND ");
			strSql.append(W83bListadosBD.territorio).append("=").append("?");
			params.add(param.getTerritorio());
		}
		if(StringUtils.isNotEmpty(param.getFechaentradahasta())){
			strSql.append(" AND ");
			strSql.append(W83bComunicacionesBD.fechaentrada).append("<=").append("TO_DATE(?,?)");
			params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaentradahasta(),param.getIdioma()), param.getIdioma()));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		
		List lista=W83bDataBase.executeQuery(strSql.toString(),params,W83bComunicacionesBean.class,param.getUsuarioBean(), null);
		lista.add("comempresas");	
		return lista;
		
		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bComunicacionesDAO#generarComunicComEmpresas(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List generarComunicComEmpresasFiscal(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT "); 
		strSql.append("TO_CHAR(").append(W83bComunicacionesBD.fechaentrada).append(",?) AS ").append(W83bListadosBD.fechaEntrada).append(" , ");
		strSql.append(W83bComunicacionesBD.territ).append(", ");
		strSql.append(W83bComunicacionesBD.razon).append(", ");
		strSql.append(W83bComunicacionesBD.domicilio).append(", ");
		strSql.append(W83bComunicacionesBD.codigopostal).append(", ");
		strSql.append(W83bComunicacionesBD.municipio).append(", ");
		strSql.append(W83bComunicacionesBD.provincia).append(", ");
		strSql.append(W83bComunicacionesBD.nacta).append(", ");
		strSql.append(W83bComunicacionesBD.anoacta).append(", ");
		strSql.append(W83bComunicacionesBD.dirorig).append(", ");
		strSql.append(W83bComunicacionesBD.cporig).append(", ");
		strSql.append(W83bComunicacionesBD.munorig).append(", ");
		strSql.append(W83bComunicacionesBD.provorig);
		strSql.append(" FROM TABLE (");
	    strSql.append(W83bComunicacionesBD.comempresasfiscal);
	    //strSql.append("(?))");
	    strSql.append(")");
		strSql.append(" WHERE ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		//params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechafinimpug(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		if(StringUtils.isNotEmpty(param.getFechaentradadesde())){
			strSql.append(W83bComunicacionesBD.fechaentrada).append(">=").append("TO_DATE(?,?)");
			params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaentradadesde(),param.getIdioma()), param.getIdioma()));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getFechaentradahasta())){
			strSql.append(" AND ");
			strSql.append(W83bComunicacionesBD.fechaentrada).append("<=").append("TO_DATE(?,?)");
			params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaentradahasta(),param.getIdioma()), param.getIdioma()));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getTerritorio())){
			strSql.append(" AND ");
			strSql.append(W83bListadosBD.territorio).append("=").append("?");
			params.add(param.getTerritorio());
		}
		
		List lista=W83bDataBase.executeQuery(strSql.toString(),params,W83bComunicacionesBean.class,param.getUsuarioBean(), null);
		lista.add("comempresas");	
		return lista;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bComunicacionesDAO#generarOficioRequeMesa(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List generarOficioRequeMesa(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT "); 
		strSql.append("TO_CHAR(").append(W83bComunicacionesBD.fechaentrada).append(",?) AS ").append(W83bListadosBD.fechaEntrada).append(" , ");
		strSql.append(W83bComunicacionesBD.razon).append(", ");
		strSql.append(W83bComunicacionesBD.territ).append(", ");
		strSql.append(W83bComunicacionesBD.codigopostal).append(", ");
		strSql.append(W83bComunicacionesBD.domicilio).append(", ");
		strSql.append(W83bComunicacionesBD.provincia).append(", ");
		strSql.append(W83bComunicacionesBD.municipio).append(", ");
		strSql.append(W83bComunicacionesBD.anoacta).append(", ");
		strSql.append(W83bComunicacionesBD.nacta).append(", ");
		strSql.append(W83bComunicacionesBD.descsindicato).append(", ");
		strSql.append(W83bComunicacionesBD.dirorig).append(", ");
		strSql.append(W83bComunicacionesBD.cporig).append(", ");
		strSql.append(W83bComunicacionesBD.munorig).append(", ");
		strSql.append(W83bComunicacionesBD.provorig);
		strSql.append(" FROM ").append(W83bComunicacionesBD.comoficioreque);
		strSql.append(" WHERE ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		if(StringUtils.isNotEmpty(param.getFechaentradadesde())){
			strSql.append(W83bComunicacionesBD.fechaentrada).append(">=").append("TO_DATE(?,?)");
			params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaentradadesde(),param.getIdioma()), param.getIdioma()));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		
		if(StringUtils.isNotEmpty(param.getTerritorio())){
			strSql.append(" AND ");
			strSql.append(W83bListadosBD.territorio).append("=").append("?");
			params.add(param.getTerritorio());
		}
		
		if(StringUtils.isNotEmpty(param.getFechaentradahasta())){
			strSql.append(" AND ");
			strSql.append(W83bComunicacionesBD.fechaentrada).append("<=").append("TO_DATE(?,?)");
			params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaentradahasta(),param.getIdioma()), param.getIdioma()));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		
		if(StringUtils.isNotEmpty(param.getNumactahasta())){
			strSql.append(" AND ((");
			strSql.append(W83bComunicacionesBD.anoacta).append("=").append("? ");
			strSql.append(" AND ");
			strSql.append(W83bComunicacionesBD.nacta).append("<=").append("? ");
			strSql.append(") OR (");
			strSql.append(W83bComunicacionesBD.anoacta).append("<").append("? ");
			strSql.append(" AND ");
			strSql.append(W83bComunicacionesBD.nacta).append(">=0))");
			params.add(param.getAnyoactahasta());
			params.add(param.getNumactahasta());
			params.add(param.getAnyoactahasta());
		}

		if(StringUtils.isNotEmpty(param.getNumactadesde())){
			strSql.append(" AND ((");
			strSql.append(W83bComunicacionesBD.anoacta).append("=").append("? ");
			strSql.append(" AND ");
			strSql.append(W83bComunicacionesBD.nacta).append(">=").append("? ");
			strSql.append(") OR (");
			strSql.append(W83bComunicacionesBD.anoacta).append(">").append("? ");
			strSql.append(" AND ");
			strSql.append(W83bComunicacionesBD.nacta).append(">=0))");
			params.add(param.getAnyoactadesde());
			params.add(param.getNumactadesde());
			params.add(param.getAnyoactadesde());
		}
		
		List lista=W83bDataBase.executeQuery(strSql.toString(),params,W83bComunicacionesBean.class,param.getUsuarioBean(), null);
		lista.add("requemesa");	
		return lista;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bComunicacionesDAO#generarComunicRequeMesa(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List generarComunicRequeMesa(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT "); 
		strSql.append("TO_CHAR(").append(W83bComunicacionesBD.fechaentrada).append(",?) AS ").append(W83bListadosBD.fechaEntrada).append(" , ");
		strSql.append(W83bComunicacionesBD.territ).append(", ");
		strSql.append(W83bComunicacionesBD.razon).append(", ");
		strSql.append(W83bComunicacionesBD.domicilio).append(", ");
		strSql.append(W83bComunicacionesBD.codigopostal).append(", ");
		strSql.append(W83bComunicacionesBD.municipio).append(", ");
		strSql.append(W83bComunicacionesBD.provincia).append(", ");
		strSql.append(W83bComunicacionesBD.nacta).append(", ");
		strSql.append(W83bComunicacionesBD.anoacta).append(", ");
		strSql.append(W83bComunicacionesBD.dirorig).append(", ");
		strSql.append(W83bComunicacionesBD.cporig).append(", ");
		strSql.append(W83bComunicacionesBD.munorig).append(", ");
		strSql.append(W83bComunicacionesBD.provorig);
		strSql.append(" FROM ").append(W83bComunicacionesBD.comrequemesa);
		strSql.append(" WHERE ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		if(StringUtils.isNotEmpty(param.getFechaentradadesde())){
			strSql.append(W83bComunicacionesBD.fechaentrada).append(">=").append("TO_DATE(?,?)");
			params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaentradadesde(),param.getIdioma()), param.getIdioma()));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		
		if(StringUtils.isNotEmpty(param.getFechaentradahasta())){
			strSql.append(" AND ");
			strSql.append(W83bComunicacionesBD.fechaentrada).append("<=").append("TO_DATE(?,?)");
			params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaentradahasta(),param.getIdioma()), param.getIdioma()));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}

		if(StringUtils.isNotEmpty(param.getTerritorio())){
			strSql.append(" AND ");
			strSql.append(W83bListadosBD.territorio).append("=").append("?");
			params.add(param.getTerritorio());
		}
		if(StringUtils.isNotEmpty(param.getNumactadesde())){
			strSql.append(" AND ((");
			strSql.append(W83bComunicacionesBD.anoacta).append("=").append("? ");
			strSql.append(" AND ");
			strSql.append(W83bComunicacionesBD.nacta).append(">=").append("? ");
			strSql.append(") OR (");
			strSql.append(W83bComunicacionesBD.anoacta).append(">").append("? ");
			strSql.append(" AND ");
			strSql.append(W83bComunicacionesBD.nacta).append(">=0))");
			params.add(param.getAnyoactadesde());
			params.add(param.getNumactadesde());
			params.add(param.getAnyoactadesde());
		}
		if(StringUtils.isNotEmpty(param.getNumactahasta())){
			strSql.append(" AND ((");
			strSql.append(W83bComunicacionesBD.anoacta).append("=").append("? ");
			strSql.append(" AND ");
			strSql.append(W83bComunicacionesBD.nacta).append("<=").append("? ");
			strSql.append(") OR (");
			strSql.append(W83bComunicacionesBD.anoacta).append("<").append("? ");
			strSql.append(" AND ");
			strSql.append(W83bComunicacionesBD.nacta).append(">=0))");
			params.add(param.getAnyoactahasta());
			params.add(param.getNumactahasta());
			params.add(param.getAnyoactahasta());
		}
		List lista=W83bDataBase.executeQuery(strSql.toString(),params,W83bComunicacionesBean.class,param.getUsuarioBean(), null);
		lista.add("requemesa");	
		return lista;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bComunicacionesDAO#w83bComunicImpugResueltas(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List w83bComunicImpugResueltas(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT "); 
		strSql.append(W83bComunicacionesBD.nacta).append(", ");
		strSql.append(W83bComunicacionesBD.anoacta).append(", ");
		strSql.append(W83bComunicacionesBD.territ).append(", ");
		strSql.append(W83bComunicacionesBD.razon).append(", ");
		strSql.append(W83bComunicacionesBD.domicilio).append(", ");
		strSql.append(W83bComunicacionesBD.municipio).append(", ");
		strSql.append(W83bComunicacionesBD.provincia).append(", ");
		strSql.append(W83bComunicacionesBD.codigopostal).append(", ");
		strSql.append(W83bComunicacionesBD.orderby).append(", ");
		strSql.append(W83bComunicacionesBD.nimpug).append(", ");
		strSql.append(W83bComunicacionesBD.dirorig).append(", ");
		strSql.append(W83bComunicacionesBD.cporig).append(", ");
		strSql.append(W83bComunicacionesBD.munorig).append(", ");
		strSql.append(W83bComunicacionesBD.provorig).append(",");
		strSql.append(W83bComunicacionesBD.nactacompleto);
		strSql.append(" FROM TABLE (");
	    strSql.append(W83bComunicacionesBD.comimpugresueltas);
	    strSql.append("(?,?,?,?))");
	    params.add(param.getFechaimpugdesde());
	    params.add(param.getFechaimpughasta());
	    params.add(param.getTerritorio());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		//
		String desde = param.getAnyoactadesde();
		String hasta = param.getAnyoactahasta();
		String numDesde = param.getNumactadesde();
		String numHasta = param.getNumactahasta();
		if(StringUtils.isEmpty(param.getAnyoactadesde())){
			desde = "0000";
		}
		if(StringUtils.isEmpty(param.getAnyoactahasta())){
			hasta = "9999";
		}
		if(StringUtils.isEmpty(param.getNumactadesde())){
			numDesde = "000000";
		}else if(6>param.getNumactadesde().length()){
			for(int i = param.getNumactadesde().length(),size = 6;i<size;i++){
				numDesde = "0"+numDesde;//NOPMD
			}
		}
		if(StringUtils.isEmpty(param.getNumactahasta())){
			numHasta = "999999";
		}else if(6>param.getNumactahasta().length()){
			for(int i = param.getNumactahasta().length(),size = 6;i<size;i++){
				numHasta = "0"+numHasta;//NOPMD
			}
		}
		
		desde = desde + numDesde;//NOPMD
		hasta = hasta + numHasta;//NOPMD
		strSql.append(" WHERE ").append(W83bComunicacionesBD.nactacompleto).append(" >= ?");			
		params.add(BigDecimal.valueOf(Long.parseLong(desde)));
		strSql.append(" AND ").append(W83bComunicacionesBD.nactacompleto).append(" <= ?");
		params.add(BigDecimal.valueOf(Long.parseLong(hasta)));
		//
		
		return W83bDataBase.executeQuery(strSql.toString(),params,W83bComunicacionesBean.class,param.getUsuarioBean(), null); 
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bComunicacionesDAO#w83bComunicLaudosResueltos(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List w83bComunicLaudosResueltos(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT "); 
		strSql.append(W83bComunicacionesBD.nacta).append(", ");
		strSql.append(W83bComunicacionesBD.anoacta).append(", ");
		strSql.append(W83bComunicacionesBD.territ).append(", ");
		strSql.append(W83bComunicacionesBD.razon).append(", ");
		strSql.append(W83bComunicacionesBD.domicilio).append(", ");
		strSql.append(W83bComunicacionesBD.municipio).append(", ");
		strSql.append(W83bComunicacionesBD.provincia).append(", ");
		strSql.append(W83bComunicacionesBD.codigopostal).append(", ");
		strSql.append(W83bComunicacionesBD.orderby).append(", ");
		strSql.append(W83bComunicacionesBD.nimpug).append(", ");
		strSql.append(W83bComunicacionesBD.dirorig).append(", ");
		strSql.append(W83bComunicacionesBD.cporig).append(", ");
		strSql.append(W83bComunicacionesBD.munorig).append(", ");
		strSql.append(W83bComunicacionesBD.provorig);
		strSql.append(" FROM TABLE (");
	    strSql.append(W83bComunicacionesBD.comlaudosresueltos);
	    strSql.append("(?))");
	    params.add(param.getTerritorio());
	    //
		String desde = param.getAnyoactadesde();
		String hasta = param.getAnyoactahasta();
		String numDesde = param.getNumactadesde();
		String numHasta = param.getNumactahasta();
		if(StringUtils.isEmpty(param.getAnyoactadesde())){
			desde = "0000";
		}
		if(StringUtils.isEmpty(param.getAnyoactahasta())){
			hasta = "9999";
		}
		if(StringUtils.isEmpty(param.getNumactadesde())){
			numDesde = "000000";
		}else if(6>param.getNumactadesde().length()){
			for(int i = param.getNumactadesde().length(),size = 6;i<size;i++){
				numDesde = "0"+numDesde;//NOPMD
			}
		}
		if(StringUtils.isEmpty(param.getNumactahasta())){
			numHasta = "999999";
		}else if(6>param.getNumactahasta().length()){
			for(int i = param.getNumactahasta().length(),size = 6;i<size;i++){
				numHasta = "0"+numHasta;//NOPMD
			}
		}
		
		desde = desde + numDesde;//NOPMD
		hasta = hasta + numHasta;//NOPMD
		strSql.append(" WHERE ").append(W83bComunicacionesBD.nactacompleto).append(" >= ?");			
		params.add(BigDecimal.valueOf(Long.parseLong(desde)));
		strSql.append(" AND ").append(W83bComunicacionesBD.nactacompleto).append(" <= ?");
		params.add(BigDecimal.valueOf(Long.parseLong(hasta)));
		//
		return W83bDataBase.executeQuery(strSql.toString(),params,W83bComunicacionesBean.class,param.getUsuarioBean(), null);	
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bComunicacionesDAO#w83bComunicResolDeneg(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List w83bComunicResolDeneg(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		List listaActas = new ArrayList();
		if ("1".equals(param.getOpcion())){
			strSql.append("SELECT "); 
			strSql.append("TO_CHAR(").append(W83bComunicacionesBD.fechaentrada).append(",?) AS ").append(W83bComunicacionesBD.fechaentrada).append(" , ");
			strSql.append(W83bComunicacionesBD.nacta).append(", ");
			strSql.append(W83bComunicacionesBD.anoacta).append(", ");
			strSql.append(W83bComunicacionesBD.razon).append(", ");
			strSql.append(W83bComunicacionesBD.domicilio).append(", ");
			strSql.append(W83bComunicacionesBD.municipio).append(", ");
			strSql.append(W83bComunicacionesBD.codigopostal).append(", ");
			strSql.append(W83bComunicacionesBD.provincia).append(", ");
			strSql.append(W83bComunicacionesBD.territ);
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			strSql.append(" FROM ").append(W83bComunicacionesBD.comfaltapreaviso);
			strSql.append(" WHERE ");
			if(StringUtils.isNotEmpty(param.getFechaentradadesde())){
				strSql.append(W83bComunicacionesBD.fechaentrada).append(">=").append("TO_DATE(?,?)");
				params.add(param.getFechaentradadesde());
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}
			if(StringUtils.isNotEmpty(param.getFechaentradahasta())){
				if(StringUtils.isNotEmpty(param.getFechaentradadesde())){
					strSql.append(" AND ");
				}
				strSql.append(W83bComunicacionesBD.fechaentrada).append("<=").append("TO_DATE(?,?)");
				params.add(param.getFechaentradahasta());
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}
			if(StringUtils.isNotEmpty(param.getTerritorio())){
				if(StringUtils.isNotEmpty(param.getTerritorio())){
					strSql.append(" AND ");
				}
				strSql.append(W83bComunicacionesBD.territ).append("=").append("?");
			}
			params.add(param.getTerritorio());
			listaActas = W83bDataBase.executeQuery(strSql.toString(),params,W83bComunicacionesBean.class,param.getUsuarioBean(), null);
			listaActas.add("faltapre");
		}
		else if ("2".equals(param.getOpcion())){
			strSql.append("SELECT "); 
			strSql.append(W83bComunicacionesBD.nacta).append(", ");
			strSql.append(W83bComunicacionesBD.anoacta).append(", ");
			strSql.append(W83bComunicacionesBD.territ).append(", ");
			strSql.append(W83bComunicacionesBD.razon).append(", ");
			strSql.append(W83bComunicacionesBD.domicilio).append(", ");
			strSql.append(W83bComunicacionesBD.municipio).append(", ");
			strSql.append(W83bComunicacionesBD.provincia).append(", ");
			strSql.append(W83bComunicacionesBD.codigopostal);
			strSql.append(" FROM TABLE (");
		    strSql.append(W83bComunicacionesBD.comlaudonegativo);
		    strSql.append("(?,?,?))");
		    params.add(param.getFechalaudodesde());
		    params.add(param.getTerritorio());
		    params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			listaActas = W83bDataBase.executeQuery(strSql.toString(),params,W83bComunicacionesBean.class,param.getUsuarioBean(), null);
			listaActas.add("laudonegativo");
		}
		
		
		return listaActas;	
	}
	
	public String obtenerDatosComunicacion(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception {
		String resul="";
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bRespAreaBD.responsable).append(" AS NOMBRE ");
		strSql.append(",");
		strSql.append(W83bRespAreaBD.sexo).append(" AS SEXO ");
		// TODO Auto-generated method stub
		strSql.append(" FROM ").append(W83bRespAreaBD.respAreaTable);
		strSql.append(" WHERE ").append(W83bRespAreaBD.territorio).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bRespAreaBD.perfil).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bRespAreaBD.baja).append(" IS NULL ");
		params.add((String)param.getTerritorio());
		params.add((String)param.getFirmante());		
		List lista = W83bDataBase.executeQuery(strSql.toString(), params, null);
		
		if(lista.size()>0)
		{	
			resul=(String)((HashMap)lista.get(0)).get("NOMBRE");
			resul=resul+"|";//NOPMD
			resul=resul+(String)((HashMap)lista.get(0)).get("SEXO");//NOPMD
		}
		return resul;
		
}
	
	public String obtenerDescPerfil(w83b.w83bBeans.W83bComunicacionesBean param, String sexo, String idioma) throws Exception {
		String resul="";
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
			if (W83bClsConstantes.CONSTANTE_VARON.equals(sexo)){
				strSql.append("'EL '").append("||").append(W83bRespAreaBD.perfildesc).append(" AS NOMBRE ");
			}
			else if (W83bClsConstantes.CONSTANTE_MUJER.equals(sexo)){
				strSql.append("'LA '").append("||").append(W83bRespAreaBD.perfilfemenino).append(" AS NOMBRE ");
			}
			else{
				strSql.append("'EL '").append("||").append(W83bRespAreaBD.perfildesc).append("||'/'||").append(W83bRespAreaBD.perfilfemenino).append(" AS NOMBRE ");
			}
		}
		else{
			strSql.append(W83bRespAreaBD.perfildese).append(" AS NOMBRE ");
		}
		// TODO Auto-generated method stub
		strSql.append(" FROM ").append(W83bRespAreaBD.perfilesTable);
		strSql.append(" WHERE ").append(W83bRespAreaBD.codperfil).append(" = ?");
		params.add((String)param.getFirmante());		
		List lista = W83bDataBase.executeQuery(strSql.toString(), params, null);
		
		if(lista.size()>0)
		{	
			resul=(String)((HashMap)lista.get(0)).get("NOMBRE");
			
		}
		return resul;
		
}
	
	public w83b.w83bBeans.W83bComunicacionesBean obtenerMunicipio(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		String m="";
		String p="";
		List params = new ArrayList();
		
	    strSql.append("SELECT ");

	    strSql.append(W83bComunicacionesBD.dso).append(" AS ").append(W83bComunicacionesBD.descmunicipio);

	    strSql.append(" FROM ");
	    
	    strSql.append(W83bComunicacionesBD.tablamunicipio);
	    
	    strSql.append(" WHERE ");
	    
	    strSql.append(W83bComunicacionesBD.provinciaid).append("=?");
	    
	    strSql.append(" AND ");
	    
	    strSql.append(W83bComunicacionesBD.id).append("=?");
	    
	    String provincia="";
	    String municipio="";
	    
	    if (W83bClsConstantes.CONSTANTE_NO_VALIDADA.equals(param.getCentroSel())||StringUtils.isEmpty(param.getProvorig())){
	    	provincia=param.getProvincia();
	    }
	    else{
	    	provincia=param.getProvorig();
	    }
	    
	    if (provincia.length()==1){
	    	p="0"+provincia;
	    }
	    else{
	    	p=provincia;
	    }
	    
	    if (W83bClsConstantes.CONSTANTE_NO_VALIDADA.equals(param.getCentroSel())||StringUtils.isEmpty(param.getMunorig())){
	    	municipio=param.getMunicipio();
	    }
	    else{
	    	municipio=param.getMunorig();
	    }
	    
	    if (municipio.length()==1){
	    	m="00"+municipio;
	    }else if (municipio.length()==2){
	    	m="0"+municipio;
	    }
	    else{
	    	m=municipio;
	    }
	    
	    params.add(p);
	    params.add(m);
		
	    List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bComunicacionesBean.class,param.getUsuarioBean(), null);
	    
	   return (W83bComunicacionesBean)lista.get(0);		
	    
		
		
	}
	
	public w83b.w83bBeans.W83bComunicacionesBean obtenerProvincia(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		String p="";
		List params = new ArrayList();
		
	    strSql.append("SELECT ");

	    strSql.append(W83bComunicacionesBD.dso).append(" AS ").append(W83bComunicacionesBD.descprovincia);

	    strSql.append(" FROM ");
	    
	    strSql.append(W83bComunicacionesBD.tablaprovincia);
	    
	    strSql.append(" WHERE ");
	    
	    strSql.append(W83bComunicacionesBD.id).append("=?");
	    
	    String provincia="";
	    
	    if (W83bClsConstantes.CONSTANTE_NO_VALIDADA.equals(param.getCentroSel())||StringUtils.isEmpty(param.getProvorig())){
	    	provincia=param.getProvincia();
	    }
	    else{
	    	provincia=param.getProvorig();
	    }
	    
	    if (provincia.length()==1){
	    	p="0"+provincia;
	    }
	    else{
	    	p=provincia;
	    }
	    
	    params.add(p);
		
	    List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bComunicacionesBean.class,param.getUsuarioBean(), null);
	    
		return (W83bComunicacionesBean)lista.get(0);		
		
	}
	
	public java.lang.String actFechaReque(List param) throws Exception{
		List params;
		W83bComunicacionesBean lb;
		for (int i=0;i<param.size()-1;i++){
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
			params = new ArrayList();//NOPMD
			lb = (W83bComunicacionesBean)param.get(i);
			strSql.append("UPDATE ");
			strSql.append(W83bActasBD.tablaActas);
			strSql.append(" SET ");
			strSql.append(W83bActasBD.fechaRequerimiento).append(" = TO_DATE(?,'DD/mm/YYYY') ");
			strSql.append(" WHERE ");
			strSql.append(W83bActasBD.numActa).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bActasBD.anyoActa).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bActasBD.codTerritActa).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bActasBD.versionActa).append("=?");
			SimpleDateFormat sdf =new SimpleDateFormat("dd/MM/yyyy");//NOPMD
		    params.add(sdf.format(new Date()));//NOPMD
			params.add(lb.getNacta());
			params.add(lb.getAnoacta());
			params.add(lb.getTerrit());
			params.add("0");
			W83bDataBase.executeTableMovement(strSql.toString(), params, null);
		}
		
		
		return "0";		
	}
	
public java.lang.String insertarTramite(W83bDocBean doc) throws Exception{
	
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("INSERT INTO ");
		strSql.append(W83bPreavisosBD.historial_tramitacion_Synonym);
		strSql.append("(");
		strSql.append(W83bPreavisosBD.n_preaviso_056);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.ano_preaviso_056);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.c_territ_056);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.c_fase_056);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.f_actu_056);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.usua_056);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.c_tram_056);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.f_tram_056);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.f_reg_sal_056);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.n_reg_sal_056);
		strSql.append(")");
		

		strSql.append(" VALUES (?,?,?,?,to_Date(?,?),?,?,to_Date(?,?),to_Date(?,?),?)");
		
		params.add(new Integer(doc.getNumActa()));
		params.add(new Integer(doc.getNumActaAno()));
		params.add(doc.getNumActaTerritorio());
		params.add(new Integer(doc.getCodFase()));
		SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN);
		params.add(sdf.format(new Date()));
		params.add(W83bDateUtil.ES_PATTERN);
		params.add(doc.getUsuario().toUpperCase());
		params.add(new Integer(doc.getCodTramite()));
		params.add(doc.getFechaRegistro());
		params.add(W83bDateUtil.ES_PATTERN_HORA_INSERT);
		params.add(doc.getFechaRegistro());
		params.add(W83bDateUtil.ES_PATTERN_HORA_INSERT);
		params.add(doc.getNumeroRegistro());
		long milisegundos = System.currentTimeMillis();
		W83bDataBase.executeBlobTableMovement(strSql.toString(), params,doc.getTamanyo(),doc.getUsuarioBean());
		W83bClsTrazas.trazaError(null, "tiempo de la insert ="+(System.currentTimeMillis()- milisegundos), null);
		return "0";		
	}

public java.lang.String modificarTramite(W83bDocBean doc) throws Exception{
	
	StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
	List params = new ArrayList();

	strSql.append("UPDATE ") ;
	strSql.append(W83bPreavisosBD.historial_tramitacion_Synonym);
	strSql.append(" SET ");
	strSql.append(W83bPreavisosBD.usu_mod_056);
	strSql.append(" = ?");
	strSql.append(",");
	strSql.append(W83bPreavisosBD.f_modif_056);
	strSql.append(" = to_date(?,?)");
	strSql.append(",");
	strSql.append(W83bPreavisosBD.n_reg_sal_056);
	strSql.append(" = ?");
	strSql.append(",");
	strSql.append(W83bPreavisosBD.f_reg_sal_056);
	strSql.append(" = to_date(?,?)");
	strSql.append(",");
	strSql.append(W83bPreavisosBD.f_tram_056);
	strSql.append(" = to_date(?,?)");
	strSql.append(" WHERE ").append(W83bPreavisosBD.n_preaviso_056).append(" = ? ");
	strSql.append(" AND ").append(W83bPreavisosBD.ano_preaviso_056).append(" = ? ");
	strSql.append(" AND ").append(W83bPreavisosBD.c_territ_056).append(" = ? ");
	strSql.append(" AND ").append(W83bPreavisosBD.c_fase_056).append(" = ? ");
	strSql.append(" AND ").append(W83bPreavisosBD.c_tram_056).append(" = ? ");
	
	params.add(doc.getUsuario().toUpperCase());
	SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN);
	params.add(sdf.format(new Date()));
	params.add(W83bDateUtil.ES_PATTERN);
	params.add(doc.getNumeroRegistro());
	params.add(doc.getFechaRegistro());
	params.add(W83bDateUtil.ES_PATTERN_HORA_INSERT);
	params.add(doc.getFechaRegistro());
	params.add(W83bDateUtil.ES_PATTERN_HORA_INSERT);
	params.add(new Integer(doc.getNumActa()));		
	params.add(new Integer(doc.getNumActaAno()));
	params.add(doc.getNumActaTerritorio());
	params.add(new Integer(doc.getCodFase()));
	params.add(new Integer(doc.getCodTramite()));
	
	long milisegundos = System.currentTimeMillis();
	W83bDataBase.executeBlobTableMovement(strSql.toString(), params,doc.getTamanyo(),doc.getUsuarioBean());
	W83bClsTrazas.trazaError(null, "tiempo de la update ="+(System.currentTimeMillis()- milisegundos), null);
	return "0";		
}
	
	public java.lang.String insertarComunicInd(W83bDocBean doc) throws Exception{
		
		StringBuffer strSqlCorrelativo = new StringBuffer(W83bClsConstantes.VEINTE);
		strSqlCorrelativo.append("SELECT MAX(");
		strSqlCorrelativo.append(W83bPreavisosBD.id_docu_038);
		strSqlCorrelativo.append(") FROM ");
		strSqlCorrelativo.append(W83bPreavisosBD.preavisos_docsTable);
		
		List idDoc = W83bDataBase.executeSimpleQuery(strSqlCorrelativo.toString(),new ArrayList(),null);
		int idDocNext=1;
		
		if (idDoc!=null && idDoc.size()>0 && idDoc.get(0)!=null)
		{
			idDocNext=Integer.parseInt(idDoc.get(0).toString())+1;
		}
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("INSERT INTO ");
		strSql.append(W83bPreavisosBD.preavisos_docsTable);
		
		strSql.append("(");
		strSql.append(W83bPreavisosBD.id_docu_038);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.nomb_docu_038);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.long_docu_038);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.docu_038);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.c_territ_038);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.c_fase_038);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.c_tram_038);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.ano_preaviso_038);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.n_preaviso_038);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.tp_doc_038);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.f_reg_038);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.num_reg_038);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.usuario_038);
		strSql.append(")");
		

		strSql.append(" VALUES (?,?,?,?,?,?,?,?,?,?,to_Date(?,?),?,?)");
		
		params.add(new Integer(idDocNext));
		params.add(doc.getNombre());
		params.add(new Integer(doc.getTamanyo()));
		params.add(doc.getFileData());
		params.add(doc.getNumActaTerritorio());
		params.add(new Integer(doc.getCodFase()));
		params.add(new Integer(doc.getCodTramite()));
		params.add(new Integer(doc.getNumActaAno()));
		params.add(new Integer(doc.getNumActa()));
		params.add(new Integer(doc.getTipoDocumento()));
		params.add(doc.getFechaRegistro());
		params.add(W83bDateUtil.ES_PATTERN_HORA_INSERT);
		params.add(doc.getNumeroRegistro());
		params.add(doc.getUsuario().toUpperCase());
		long milisegundos = System.currentTimeMillis();
		W83bDataBase.executeBlobTableMovement(strSql.toString(), params,doc.getTamanyo(),doc.getUsuarioBean());
		W83bClsTrazas.trazaError(null, "tiempo de la insert ="+(System.currentTimeMillis()- milisegundos), null);
		return "0";		
	}
	
	public String obtenerTipodocumento(w83b.w83bBeans.W83bDocBean param) throws Exception {
		String resul="";
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bActasBD.tip_id);
		strSql.append(" AS ID ");
		strSql.append(" FROM ").append(W83bActasBD.tipos_doc_table);
		strSql.append(" WHERE ").append(W83bActasBD.tip_tram).append(" = ?");
		params.add((String)param.getCodTramite());	
		strSql.append(" AND ").append(W83bActasBD.tip_fase).append(" = ?");
		params.add(new Integer(param.getCodFase()));		
		List lista = W83bDataBase.executeQuery(strSql.toString(), params, null);
		
		if(lista.size()>0)
		{	
			resul=((HashMap)lista.get(0)).get("ID").toString();
			
		}
		return resul;
		
}
	
	public boolean existePreavisoTramite(w83b.w83bBeans.W83bDocBean param) throws Exception {
		boolean resul=false;
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bPreavisosBD.n_preaviso_056);
		strSql.append(" FROM ").append(W83bPreavisosBD.historial_tramitacion_Synonym);
		strSql.append(" WHERE ");
		strSql.append(W83bPreavisosBD.n_preaviso_056);
		strSql.append("=? AND ");
		strSql.append(W83bPreavisosBD.ano_preaviso_056);
		strSql.append("=? AND ");
		strSql.append(W83bPreavisosBD.c_territ_056);
		strSql.append("=? AND ");
		strSql.append(W83bPreavisosBD.c_fase_056);
		strSql.append("=? AND ");
		strSql.append(W83bPreavisosBD.c_tram_056);
		strSql.append("=?");
		params.add(new Integer(param.getNumActa()));
		params.add(new Integer(param.getNumActaAno()));
		params.add(param.getNumActaTerritorio());
		params.add(new Integer(param.getCodFase()));
		params.add(new Integer(param.getCodTramite()));
		List lista = W83bDataBase.executeQuery(strSql.toString(), params, null);
		
		if(lista.size()>0)
		{	
			resul=true;
			
		}
		return resul;
		
}
	
	public java.lang.String insertarTramiteActa(W83bDocBean doc) throws Exception{
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("INSERT INTO ");
		strSql.append(W83bActasBD.historial_tramitacion_Synonym);
		strSql.append("(");
		strSql.append(W83bActasBD.hisTram_numActa);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_anyoActa);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_territActa);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_fase);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_fechaActualizacion);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_usuario);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_tram);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_fechaTram);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_fechaRegSal);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_numRegSal);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_versionActa);
		strSql.append(")");
		

		strSql.append(" VALUES (?,?,?,?,to_Date(?,?),?,?,to_Date(?,?),to_Date(?,?),?,?)");
		
		params.add(new Integer(doc.getNumActa()));
		params.add(new Integer(doc.getNumActaAno()));
		params.add(doc.getNumActaTerritorio());
		params.add(new Integer(doc.getCodFase()));
		SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN);
		params.add(sdf.format(new Date()));
		params.add(W83bDateUtil.ES_PATTERN);
		params.add(doc.getUsuario().toUpperCase());
		params.add(new Integer(doc.getCodTramite()));
		params.add(doc.getFechaRegistro());
		params.add(W83bDateUtil.ES_PATTERN_HORA_INSERT);
		params.add(doc.getFechaRegistro());
		params.add(W83bDateUtil.ES_PATTERN_HORA_INSERT);
		params.add(doc.getNumeroRegistro());
		params.add(doc.getVersionActa());
		long milisegundos = System.currentTimeMillis();
		W83bDataBase.executeBlobTableMovement(strSql.toString(), params,doc.getTamanyo(),doc.getUsuarioBean());
		W83bClsTrazas.trazaError(null, "tiempo de la insert ="+(System.currentTimeMillis()- milisegundos), null);
		return "0";		
	}

	public java.lang.String modificarTramiteActa(W83bDocBean doc) throws Exception{
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
	
		strSql.append("UPDATE ") ;
		strSql.append(W83bActasBD.historial_tramitacion_Synonym);
		strSql.append(" SET ");
		strSql.append(W83bActasBD.hisTram_usuarioModificacion);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_fechaModificacion);
		strSql.append(" = to_date(?,?)");
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_numRegSal);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_fechaRegSal);
		strSql.append(" = to_date(?,?)");
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_fechaTram);
		strSql.append(" = to_date(?,?)");
		strSql.append(" WHERE ").append(W83bActasBD.hisTram_numActa).append(" = ? ");
		strSql.append(" AND ").append(W83bActasBD.hisTram_anyoActa).append(" = ? ");
		strSql.append(" AND ").append(W83bActasBD.hisTram_territActa).append(" = ? ");
		strSql.append(" AND ").append(W83bActasBD.hisTram_versionActa).append(" = ? ");
		strSql.append(" AND ").append(W83bActasBD.hisTram_fase).append(" = ? ");
		strSql.append(" AND ").append(W83bActasBD.hisTram_tram).append(" = ? ");
		
		params.add(doc.getUsuario().toUpperCase());
		SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN);
		params.add(sdf.format(new Date()));
		params.add(W83bDateUtil.ES_PATTERN);
		params.add(doc.getNumeroRegistro());
		params.add(doc.getFechaRegistro());
		params.add(W83bDateUtil.ES_PATTERN_HORA_INSERT);
		params.add(doc.getFechaRegistro());
		params.add(W83bDateUtil.ES_PATTERN_HORA_INSERT);
		params.add(new Integer(doc.getNumActa()));		
		params.add(new Integer(doc.getNumActaAno()));
		params.add(doc.getNumActaTerritorio());
		params.add(doc.getVersionActa());
		params.add(new Integer(doc.getCodFase()));
		params.add(new Integer(doc.getCodTramite()));
		
		long milisegundos = System.currentTimeMillis();
		W83bDataBase.executeBlobTableMovement(strSql.toString(), params,doc.getTamanyo(),doc.getUsuarioBean());
		W83bClsTrazas.trazaError(null, "tiempo de la update ="+(System.currentTimeMillis()- milisegundos), null);
		return "0";		
	}
	
	public java.lang.String insertarComunicIndActa(W83bDocBean doc) throws Exception{
		
		StringBuffer strSqlCorrelativo = new StringBuffer(W83bClsConstantes.VEINTE);
		strSqlCorrelativo.append("SELECT MAX(");
		strSqlCorrelativo.append(W83bActasBD.doc_id);
		strSqlCorrelativo.append(") FROM ");
		strSqlCorrelativo.append(W83bActasBD.actas_docsTable);
		
		List idDoc = W83bDataBase.executeSimpleQuery(strSqlCorrelativo.toString(),new ArrayList(),null);
		int idDocNext=1;
		
		if (idDoc!=null && idDoc.size()>0 && idDoc.get(0)!=null)
		{
			idDocNext=Integer.parseInt(idDoc.get(0).toString())+1;
		}
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("INSERT INTO ");
		strSql.append(W83bActasBD.actas_docsTable);
		
		strSql.append("(");
		strSql.append(W83bActasBD.doc_id);
		strSql.append(",");
		strSql.append(W83bActasBD.doc_nombre);
		strSql.append(",");
		strSql.append(W83bActasBD.doc_longitud);
		strSql.append(",");
		strSql.append(W83bActasBD.doc_documento);
		strSql.append(",");
		strSql.append(W83bActasBD.doc_territActa);
		strSql.append(",");
		strSql.append(W83bActasBD.doc_tram);
		strSql.append(",");
		strSql.append(W83bActasBD.doc_fase);
		strSql.append(",");
		strSql.append(W83bActasBD.doc_anyoActa);
		strSql.append(",");
		strSql.append(W83bActasBD.doc_numActa);
		strSql.append(",");
		strSql.append(W83bActasBD.doc_tipo);
		strSql.append(",");
		strSql.append(W83bActasBD.doc_numReg);
		strSql.append(",");
		strSql.append(W83bActasBD.doc_fechaReg);
		strSql.append(",");
		strSql.append(W83bActasBD.doc_usuario);
		strSql.append(",");
		strSql.append(W83bActasBD.doc_versionActa);
		strSql.append(")");
		

		strSql.append(" VALUES (?,?,?,?,?,?,?,?,?,?,?,to_Date(?,?),?,?)");
		
		params.add(new Integer(idDocNext));
		params.add(doc.getNombre());
		params.add(new Integer(doc.getTamanyo()));
		params.add(doc.getFileData());
		params.add(doc.getNumActaTerritorio());
		params.add(new Integer(doc.getCodTramite()));
		params.add(new Integer(doc.getCodFase()));
		params.add(new Integer(doc.getNumActaAno()));
		params.add(new Integer(doc.getNumActa()));
		params.add(new Integer(doc.getTipoDocumento()));
		params.add(doc.getNumeroRegistro());
		params.add(doc.getFechaRegistro());
		params.add(W83bDateUtil.ES_PATTERN_HORA_INSERT);
		params.add(doc.getUsuario().toUpperCase());
		params.add(doc.getVersionActa());
		long milisegundos = System.currentTimeMillis();
		W83bDataBase.executeBlobTableMovement(strSql.toString(), params,doc.getTamanyo(),doc.getUsuarioBean());
		W83bClsTrazas.trazaError(null, "tiempo de la insert ="+(System.currentTimeMillis()- milisegundos), null);
		return "0";		
	}
	
	public boolean existeActaTramite(w83b.w83bBeans.W83bDocBean param) throws Exception {
		boolean resul=false;
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bActasBD.hisTram_numActa);
		strSql.append(" FROM ").append(W83bActasBD.historial_tramitacion_Synonym);
		strSql.append(" WHERE ");
		strSql.append(W83bActasBD.hisTram_numActa);
		strSql.append("=? AND ");
		strSql.append(W83bActasBD.hisTram_anyoActa);
		strSql.append("=? AND ");
		strSql.append(W83bActasBD.hisTram_territActa);
		strSql.append("=? AND ");
		strSql.append(W83bActasBD.hisTram_versionActa);
		strSql.append("=? AND ");
		strSql.append(W83bActasBD.hisTram_fase);
		strSql.append("=? AND ");
		strSql.append(W83bActasBD.hisTram_tram);
		strSql.append("=?");
		params.add(new Integer(param.getNumActa()));
		params.add(new Integer(param.getNumActaAno()));
		params.add(param.getNumActaTerritorio());
		params.add(param.getVersionActa());
		params.add(new Integer(param.getCodFase()));
		params.add(new Integer(param.getCodTramite()));
		List lista = W83bDataBase.executeQuery(strSql.toString(), params, null);
		
		if(lista.size()>0)
		{	
			resul=true;
			
		}
		return resul;
		
}
	
public java.lang.String insertarTramiteImpug(W83bDocBean doc) throws Exception{
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("INSERT INTO ");
		strSql.append(W83bMigracionBD.tabla71);
		strSql.append("(");
		strSql.append(W83bImpugnacionesBD.numImpugnacionTram);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.anyoImpugnacionTram);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.codTerritorioImpugnacionTram);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.codFase);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.ftramite);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.usu_71);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.codTramite);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.fechaAltaTramite);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.fregistro_71);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.nregistro_71);
		strSql.append(")");
		

		strSql.append(" VALUES (?,?,?,?,to_Date(?,?),?,?,to_Date(?,?),to_Date(?,?),?)");
		
		params.add(new Integer(doc.getNumActa()));
		params.add(new Integer(doc.getNumActaAno()));
		params.add(doc.getNumActaTerritorio());
		params.add(new Integer(doc.getCodFase()));
		SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN);
		params.add(sdf.format(new Date()));
		params.add(W83bDateUtil.ES_PATTERN);
		params.add(doc.getUsuario().toUpperCase());
		params.add(new Integer(doc.getCodTramite()));
		params.add(doc.getFechaRegistro());
		params.add(W83bDateUtil.ES_PATTERN_HORA_INSERT);
		params.add(doc.getFechaRegistro());
		params.add(W83bDateUtil.ES_PATTERN_HORA_INSERT);
		params.add(doc.getNumeroRegistro());
		long milisegundos = System.currentTimeMillis();
		W83bDataBase.executeBlobTableMovement(strSql.toString(), params,doc.getTamanyo(),doc.getUsuarioBean());
		W83bClsTrazas.trazaError(null, "tiempo de la insert ="+(System.currentTimeMillis()- milisegundos), null);
		return "0";		
	}

public java.lang.String insertarTramiteInc(W83bDocBean doc) throws Exception{
	
	StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
	List params = new ArrayList();

	strSql.append("INSERT INTO ");
	strSql.append(W83bIncidenciasHistorialBD.tabla72);
	strSql.append("(");
	strSql.append(W83bIncidenciasHistorialBD.N_INCID_072);
	strSql.append(",");
	strSql.append(W83bIncidenciasHistorialBD.ANO_INCID_072);
	strSql.append(",");
	strSql.append(W83bIncidenciasHistorialBD.C_TERRIT_072);
	strSql.append(",");
	strSql.append(W83bIncidenciasHistorialBD.C_FASE_072);
	strSql.append(",");
	strSql.append(W83bIncidenciasHistorialBD.F_ACTU_072);
	strSql.append(",");
	strSql.append(W83bIncidenciasHistorialBD.USUA_072);
	strSql.append(",");
	strSql.append(W83bIncidenciasHistorialBD.C_TRAM_072);
	strSql.append(",");
	strSql.append(W83bIncidenciasHistorialBD.F_TRAM_072);
	strSql.append(",");
	strSql.append(W83bIncidenciasHistorialBD.F_REG_SAL_072);
	strSql.append(",");
	strSql.append(W83bIncidenciasHistorialBD.N_REG_SAL_072);
	strSql.append(")");
	

	strSql.append(" VALUES (?,?,?,?,to_Date(?,?),?,?,to_Date(?,?),to_Date(?,?),?)");
	
	params.add(new Integer(doc.getNumInc()));
	params.add(new Integer(doc.getNumIncAno()));
	params.add(doc.getNumIncTerritorio());
	params.add(new Integer(doc.getCodFase()));
	SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN);
	params.add(sdf.format(new Date()));
	params.add(W83bDateUtil.ES_PATTERN);
	params.add(doc.getUsuario().toUpperCase());
	params.add(new Integer(doc.getCodTramite()));
	params.add(doc.getFechaRegistro());
	params.add(W83bDateUtil.ES_PATTERN_HORA_INSERT);
	params.add(doc.getFechaRegistro());
	params.add(W83bDateUtil.ES_PATTERN_HORA_INSERT);
	params.add(doc.getNumeroRegistro());
	long milisegundos = System.currentTimeMillis();
	W83bDataBase.executeBlobTableMovement(strSql.toString(), params,doc.getTamanyo(),doc.getUsuarioBean());
	W83bClsTrazas.trazaError(null, "tiempo de la insert ="+(System.currentTimeMillis()- milisegundos), null);
	return "0";		
}

public java.lang.String modificarTramiteImpug(W83bDocBean doc) throws Exception{
	
	StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
	List params = new ArrayList();

	strSql.append("UPDATE ") ;
	strSql.append(W83bMigracionBD.tabla71);
	strSql.append(" SET ");
	strSql.append(W83bImpugnacionesBD.usumod_71);
	strSql.append(" = ?");
	strSql.append(",");
	strSql.append(W83bImpugnacionesBD.fechamodif_71);
	strSql.append(" = to_date(?,?)");
	strSql.append(",");
	strSql.append(W83bImpugnacionesBD.fregistro_71);
	strSql.append(" = to_date(?,?)");
	strSql.append(",");
	strSql.append(W83bImpugnacionesBD.nregistro_71);
	strSql.append(" = ?");
	strSql.append(",");
	strSql.append(W83bImpugnacionesBD.fechaAltaTramite);
	strSql.append(" = to_date(?,?)");
	strSql.append(" WHERE ").append(W83bImpugnacionesBD.numImpugnacionTram).append(" = ? ");
	strSql.append(" AND ").append(W83bImpugnacionesBD.anyoImpugnacionTram).append(" = ? ");
	strSql.append(" AND ").append(W83bImpugnacionesBD.codTerritorioImpugnacionTram).append(" = ? ");
	strSql.append(" AND ").append(W83bImpugnacionesBD.codFase).append(" = ? ");
	strSql.append(" AND ").append(W83bImpugnacionesBD.codTramite).append(" = ? ");
	
	params.add(doc.getUsuario().toUpperCase());
	SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN);
	params.add(sdf.format(new Date()));
	params.add(W83bDateUtil.ES_PATTERN);
	params.add(doc.getFechaRegistro());
	params.add(W83bDateUtil.ES_PATTERN_HORA_INSERT);
	params.add(doc.getNumeroRegistro());
	params.add(doc.getFechaRegistro());
	params.add(W83bDateUtil.ES_PATTERN_HORA_INSERT);
	params.add(new Integer(doc.getNumActa()));		
	params.add(new Integer(doc.getNumActaAno()));
	params.add(doc.getNumActaTerritorio());
	params.add(new Integer(doc.getCodFase()));
	params.add(new Integer(doc.getCodTramite()));
	
	long milisegundos = System.currentTimeMillis();
	W83bDataBase.executeBlobTableMovement(strSql.toString(), params,doc.getTamanyo(),doc.getUsuarioBean());
	W83bClsTrazas.trazaError(null, "tiempo de la update ="+(System.currentTimeMillis()- milisegundos), null);
	return "0";		
}

public java.lang.String modificarTramiteInc(W83bDocBean doc) throws Exception{
	
	StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
	List params = new ArrayList();

	strSql.append("UPDATE ") ;
	strSql.append(W83bIncidenciasHistorialBD.tabla72);
	strSql.append(" SET ");
	strSql.append(W83bIncidenciasHistorialBD.USU_MOD_072);
	strSql.append(" = ?");
	strSql.append(",");
	strSql.append(W83bIncidenciasHistorialBD.F_MODIF_072);
	strSql.append(" = to_date(?,?)");
	strSql.append(",");
	strSql.append(W83bIncidenciasHistorialBD.F_REG_SAL_072);
	strSql.append(" = to_date(?,?)");
	strSql.append(",");
	strSql.append(W83bIncidenciasHistorialBD.N_REG_SAL_072);
	strSql.append(" = ?");
	strSql.append(",");
	strSql.append(W83bIncidenciasHistorialBD.F_TRAM_072);
	strSql.append(" = to_date(?,?)");
	strSql.append(" WHERE ").append(W83bIncidenciasHistorialBD.N_INCID_072).append(" = ? ");
	strSql.append(" AND ").append(W83bIncidenciasHistorialBD.ANO_INCID_072).append(" = ? ");
	strSql.append(" AND ").append(W83bIncidenciasHistorialBD.C_TERRIT_072).append(" = ? ");
	strSql.append(" AND ").append(W83bIncidenciasHistorialBD.C_FASE_072).append(" = ? ");
	strSql.append(" AND ").append(W83bIncidenciasHistorialBD.C_TRAM_072).append(" = ? ");
	
	params.add(doc.getUsuario().toUpperCase());
	SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN);
	params.add(sdf.format(new Date()));
	params.add(W83bDateUtil.ES_PATTERN);
	params.add(doc.getFechaRegistro());
	params.add(W83bDateUtil.ES_PATTERN_HORA_INSERT);
	params.add(doc.getNumeroRegistro());
	params.add(doc.getFechaRegistro());
	params.add(W83bDateUtil.ES_PATTERN_HORA_INSERT);
	params.add(new Integer(doc.getNumInc()));		
	params.add(new Integer(doc.getNumIncAno()));
	params.add(doc.getNumIncTerritorio());
	params.add(new Integer(doc.getCodFase()));
	params.add(new Integer(doc.getCodTramite()));
	
	long milisegundos = System.currentTimeMillis();
	W83bDataBase.executeTableMovement(strSql.toString(), params ,doc.getUsuarioBean());
	W83bClsTrazas.trazaError(null, "tiempo de la update ="+(System.currentTimeMillis()- milisegundos), null);
	return "0";		
}
	
	public java.lang.String insertarComunicIndImpug(W83bDocBean doc) throws Exception{
		
		StringBuffer strSqlCorrelativo = new StringBuffer(W83bClsConstantes.VEINTE);
		strSqlCorrelativo.append("SELECT MAX(");
		strSqlCorrelativo.append(W83bMigracionBD.idDoc41);
		strSqlCorrelativo.append(") FROM ");
		strSqlCorrelativo.append(W83bMigracionBD.tabla41);
		
		List idDoc = W83bDataBase.executeSimpleQuery(strSqlCorrelativo.toString(),new ArrayList(),null);
		int idDocNext=1;
		
		if (idDoc!=null && idDoc.size()>0 && idDoc.get(0)!=null)
		{
			idDocNext=Integer.parseInt(idDoc.get(0).toString())+1;
		}
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("INSERT INTO ");
		strSql.append(W83bMigracionBD.tabla41);
		
		strSql.append("(");
		strSql.append(W83bMigracionBD.idDoc41);
		strSql.append(",");
		strSql.append(W83bMigracionBD.nomDoc41);
		strSql.append(",");
		strSql.append(W83bMigracionBD.longDoc41);
		strSql.append(",");
		strSql.append(W83bMigracionBD.doc41);
		strSql.append(",");
		strSql.append(W83bMigracionBD.codTerrit41);
		strSql.append(",");
		strSql.append(W83bMigracionBD.codTram41);
		strSql.append(",");
		strSql.append(W83bMigracionBD.codFase41);
		strSql.append(",");
		strSql.append(W83bMigracionBD.anoImpug41);
		strSql.append(",");
		strSql.append(W83bMigracionBD.numImpug41);
		strSql.append(",");
		strSql.append(W83bMigracionBD.tipoDoc41);
		strSql.append(",");
		strSql.append(W83bMigracionBD.numReg41);
		strSql.append(",");
		strSql.append(W83bMigracionBD.fReg41);
		strSql.append(",");
		strSql.append(W83bMigracionBD.usu41);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.destinatario_com_laudo_041);
		strSql.append(")");
		

		strSql.append(" VALUES (?,?,?,?,?,?,?,?,?,?,?,to_Date(?,?),?,?)");
		
		params.add(new Integer(idDocNext));
		params.add(doc.getNombre());
		params.add(new Integer(doc.getTamanyo()));
		params.add(doc.getFileData());
		params.add(doc.getNumActaTerritorio());
		params.add(new Integer(doc.getCodTramite()));
		params.add(new Integer(doc.getCodFase()));
		params.add(new Integer(doc.getNumActaAno()));
		params.add(new Integer(doc.getNumActa()));
		params.add(new Integer(doc.getTipoDocumento()));
		params.add(doc.getNumeroRegistro());
		params.add(doc.getFechaRegistro());
		params.add(W83bDateUtil.ES_PATTERN_HORA_INSERT);
		params.add(doc.getUsuario().toUpperCase());
		params.add((doc.getDestinatarioComunicLaudo()==null || doc.getDestinatarioComunicLaudo().equals(""))?W83bClsConstantes.DESTINATARIO_LAUDO_CENTRO:doc.getDestinatarioComunicLaudo());
		long milisegundos = System.currentTimeMillis();
		W83bDataBase.executeBlobTableMovement(strSql.toString(), params,doc.getTamanyo(),doc.getUsuarioBean());
		W83bClsTrazas.trazaError(null, "tiempo de la insert ="+(System.currentTimeMillis()- milisegundos), null);
		return "0";		
	}
	
	
public java.lang.String insertarComunicIndInc(W83bDocBean doc) throws Exception{
		
		StringBuffer strSqlCorrelativo = new StringBuffer(W83bClsConstantes.VEINTE);
		strSqlCorrelativo.append("SELECT MAX(");
		strSqlCorrelativo.append(W83bMigracionBD.idDoc64);
		strSqlCorrelativo.append(") FROM ");
		strSqlCorrelativo.append(W83bMigracionBD.tabla64);
		
		List idDoc = W83bDataBase.executeSimpleQuery(strSqlCorrelativo.toString(),new ArrayList(),null);
		int idDocNext=1;
		
		if (idDoc!=null && idDoc.size()>0 && idDoc.get(0)!=null)
		{
			idDocNext=Integer.parseInt(idDoc.get(0).toString())+1;
		}
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("INSERT INTO ");
		strSql.append(W83bMigracionBD.nombretabla64);
		
		strSql.append("(");
		strSql.append(W83bMigracionBD.idDoc64);
		strSql.append(",");
		strSql.append(W83bMigracionBD.nomDoc64);
		strSql.append(",");
		strSql.append(W83bMigracionBD.longDoc64);
		strSql.append(",");
		strSql.append(W83bMigracionBD.doc64);
		strSql.append(",");
		strSql.append(W83bMigracionBD.codTerrit64);
		strSql.append(",");
		strSql.append(W83bMigracionBD.codTram64);
		strSql.append(",");
		strSql.append(W83bMigracionBD.codFase64);
		strSql.append(",");
		strSql.append(W83bMigracionBD.anoImpug64);
		strSql.append(",");
		strSql.append(W83bMigracionBD.numImpug64);
		strSql.append(",");
		strSql.append(W83bMigracionBD.tipoDoc64);
		strSql.append(",");
		strSql.append(W83bMigracionBD.numReg64);
		strSql.append(",");
		strSql.append(W83bMigracionBD.fReg64);
		strSql.append(",");
		strSql.append(W83bMigracionBD.usu64);
		strSql.append(")");
		

		strSql.append(" VALUES (?,?,?,?,?,?,?,?,?,?,?,to_Date(?,?),?)");
		
		params.add(new Integer(idDocNext));
		params.add(doc.getNombre());
		params.add(new Integer(doc.getTamanyo()));
		params.add(doc.getFileData());
		params.add(doc.getNumIncTerritorio());
		params.add(new Integer(doc.getCodTramite()));
		params.add(new Integer(doc.getCodFase()));
		params.add(new Integer(doc.getNumIncAno()));
		params.add(new Integer(doc.getNumInc()));
		params.add(new Integer(doc.getTipoDocumento()));
		params.add(doc.getNumeroRegistro());
		params.add(doc.getFechaRegistro());
		params.add(W83bDateUtil.ES_PATTERN_HORA_INSERT);
		params.add(doc.getUsuario().toUpperCase());
		long milisegundos = System.currentTimeMillis();
		W83bDataBase.executeBlobTableMovement(strSql.toString(), params,doc.getTamanyo(),doc.getUsuarioBean());
		W83bClsTrazas.trazaError(null, "tiempo de la insert ="+(System.currentTimeMillis()- milisegundos), null);
		return "0";		
	}
	
	public boolean existeImpugTramite(w83b.w83bBeans.W83bDocBean param) throws Exception {
		boolean resul=false;
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bImpugnacionesBD.numImpugnacionTram);
		strSql.append(" FROM ").append(W83bMigracionBD.tabla71);
		strSql.append(" WHERE ");
		strSql.append(W83bImpugnacionesBD.numImpugnacionTram);
		strSql.append("=? AND ");
		strSql.append(W83bImpugnacionesBD.anyoImpugnacionTram);
		strSql.append("=? AND ");
		strSql.append(W83bImpugnacionesBD.codTerritorioImpugnacionTram);
		strSql.append("=? AND ");
		strSql.append(W83bImpugnacionesBD.codFase);
		strSql.append("=? AND ");
		strSql.append(W83bImpugnacionesBD.codTramite);
		strSql.append("=?");
		params.add(new Integer(param.getNumActa()));
		params.add(new Integer(param.getNumActaAno()));
		params.add(param.getNumActaTerritorio());
		params.add(new Integer(param.getCodFase()));
		params.add(new Integer(param.getCodTramite()));
		List lista = W83bDataBase.executeQuery(strSql.toString(), params, null);
		
		if(lista.size()>0)
		{	
			resul=true;
			
		}
		return resul;
		
}
	
	public boolean existeIncTramite(w83b.w83bBeans.W83bDocBean param) throws Exception {
		boolean resul=false;
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bIncidenciasHistorialBD.N_INCID_072);
		strSql.append(" FROM ").append(W83bMigracionBD.tabla72);
		strSql.append(" WHERE ");
		strSql.append(W83bIncidenciasHistorialBD.N_INCID_072);
		strSql.append("=? AND ");
		strSql.append(W83bIncidenciasHistorialBD.ANO_INCID_072);
		strSql.append("=? AND ");
		strSql.append(W83bIncidenciasHistorialBD.C_TERRIT_072);
		strSql.append("=? AND ");
		strSql.append(W83bIncidenciasHistorialBD.C_FASE_072);
		strSql.append("=? AND ");
		strSql.append(W83bIncidenciasHistorialBD.C_TRAM_072);
		strSql.append("=?");
		params.add(new Integer(param.getNumInc()));
		params.add(new Integer(param.getNumIncAno()));
		params.add(param.getNumIncTerritorio());
		params.add(new Integer(param.getCodFase()));
		params.add(new Integer(param.getCodTramite()));
		List lista = W83bDataBase.executeQuery(strSql.toString(), params, null);
		
		if(lista.size()>0)
		{	
			resul=true;
			
		}
		return resul;
		
}
	
	public List obtenerSindImpug(String param, String territ, W83bUsuarioXLNetsBean usuario) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append("SIND.");
		strSql.append(W83bSindicatosBD.codSindicato);
		strSql.append(", SIND.");
		strSql.append(W83bSindicatosBD.descSindicatoCast);
		strSql.append(", SIND.");
		strSql.append(W83bSindicatosBD.descSindicatoEusk);
		strSql.append(" FROM ");
		strSql.append(W83bImpugnacionesSindicatosBD.impSindVista); 
		strSql.append(" SINDIMP INNER JOIN ");
		strSql.append(W83bSindicatosBD.sindicatosVista);
		strSql.append(" SIND ON SINDIMP.");
		strSql.append(W83bImpugnacionesSindicatosBD.codSind); 
		strSql.append("=SIND.");
		strSql.append(W83bSindicatosBD.codSindicato);
		strSql.append(" WHERE SINDIMP.");
		strSql.append(W83bImpugnacionesSindicatosBD.anoimpug); 
		strSql.append("=?");
		strSql.append(" AND SINDIMP.");
		strSql.append(W83bImpugnacionesSindicatosBD.territimpug); 
		strSql.append("=?");
		strSql.append(" AND SINDIMP.");
		strSql.append(W83bImpugnacionesSindicatosBD.impugnacion); 
		strSql.append("=?");
		
		String[] p=param.split("\\|");
		params.add(new Integer(p[1]));
		params.add(territ);
		params.add(new Integer(p[0]));
		
		return W83bDataBase.executeQuery(strSql.toString(),params,W83bSindicatosBean.class,usuario, null);
		
}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bComunicacionesDAO#w83bComunicLaudosResueltos(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List comunicExtraccionDatos(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT "); 
		strSql.append(W83bComunicacionesBD.nacta).append(", ");
		strSql.append(W83bComunicacionesBD.anoacta).append(", ");
		strSql.append(W83bComunicacionesBD.territ).append(", ");
		strSql.append(W83bComunicacionesBD.nimpug).append(", ");
		strSql.append(W83bComunicacionesBD.anoimpug).append(", ");
		strSql.append(W83bComunicacionesBD.nlaudo).append(", ");
		strSql.append(W83bComunicacionesBD.anolaudo).append(", ");
		strSql.append("TO_CHAR(").append(W83bComunicacionesBD.flaudo).append(",?) AS ").append(W83bComunicacionesBD.flaudo).append(" , ");
		strSql.append(W83bComunicacionesBD.arbitro).append(", ");
		strSql.append(W83bComunicacionesBD.cif).append(", ");
		strSql.append(W83bComunicacionesBD.razon).append(", ");
		strSql.append(W83bComunicacionesBD.sindicatos).append(", ");
		strSql.append(W83bComunicacionesBD.voces).append(", ");
		strSql.append(W83bComunicacionesBD.orderby);
		strSql.append(" FROM TABLE (");
	    strSql.append(W83bComunicacionesBD.extracciondatos);
	    strSql.append("(?,?,?,?))");
	    params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	    if (param.getSindicato()!=null&&StringUtils.isNotEmpty(param.getSindicato())){
	    	params.add(new Integer(param.getSindicato()));
	    }
	    else{
	    	params.add(new Integer(-1));
	    }
	    if (param.getTipoVoz()!=null&&StringUtils.isNotEmpty(param.getTipoVoz())){
	    	params.add(new Integer(param.getTipoVoz()));
	    }
	    else{
	    	params.add(new Integer(-1));
	    }
	    if (param.getVoz()!=null&&StringUtils.isNotEmpty(param.getVoz())){
	    	params.add(new Integer(param.getVoz()));
	    }
	    else{
	    	params.add(new Integer(-1));
	    }
	    if (param.getSinovoces()!=null&&W83bClsConstantes.UNO==Integer.parseInt(param.getSinovoces())){
	    	params.add(new Integer(param.getSinovoces()));
	    }
	    else{
	    	params.add(new Integer(0));
	    }
	    strSql.append(" WHERE ");
		if(StringUtils.isNotEmpty(param.getTerritorio())){
			strSql.append(W83bComunicacionesBD.territ).append("=").append("? ");
			params.add(param.getTerritorio());
		}
		if(StringUtils.isNotEmpty(param.getNumLaudoDesde())){
			strSql.append(" AND ((");
			strSql.append(W83bComunicacionesBD.anolaudo).append("=").append("? ");
			strSql.append(" AND ");
			strSql.append(W83bComunicacionesBD.nlaudo).append(">=").append("? ");
			strSql.append(") OR (");
			strSql.append(W83bComunicacionesBD.anolaudo).append(">").append("? ");
			strSql.append(" AND ");
			strSql.append(W83bComunicacionesBD.nlaudo).append(">=0))");
			params.add(param.getAnoLaudoDesde());
			params.add(param.getNumLaudoDesde());
			params.add(param.getAnoLaudoDesde());
		}
		else{
			if(StringUtils.isNotEmpty(param.getAnoLaudoDesde())){
				strSql.append(" AND ");
				strSql.append(W83bComunicacionesBD.anolaudo).append(">=").append("? ");
				params.add(param.getAnoLaudoDesde());
		}
		}
		if(StringUtils.isNotEmpty(param.getAnoLaudoHasta())){
			strSql.append(" AND ((");
			strSql.append(W83bComunicacionesBD.anolaudo).append("=").append("? ");
			strSql.append(" AND ");
			strSql.append(W83bComunicacionesBD.nlaudo).append("<=").append("? ");
			strSql.append(") OR (");
			strSql.append(W83bComunicacionesBD.anolaudo).append("<").append("? ");
			strSql.append(" AND ");
			strSql.append(W83bComunicacionesBD.nlaudo).append(">=0))");
			params.add(param.getAnoLaudoHasta());
			params.add(param.getNumLaudoHasta());
			params.add(param.getAnoLaudoHasta());
		}
		else{
			if(StringUtils.isNotEmpty(param.getAnoLaudoHasta())){
				strSql.append(" AND ");
				strSql.append(W83bComunicacionesBD.anolaudo).append("<=").append("? ");
				params.add(param.getAnoLaudoHasta());
			}
		}
		if (W83bClsConstantes.CONSTANTE_SI.equals(param.getSinfechalaudo())){
			strSql.append(" AND ");
			strSql.append(W83bComunicacionesBD.flaudo).append(" IS NULL ");
		}
		else{
			if(StringUtils.isNotEmpty(param.getFechalaudodesde())){
				strSql.append(" AND ");
				strSql.append(W83bComunicacionesBD.flaudo).append(">=").append("TO_DATE(?,?)");
				params.add(param.getFechalaudodesde());
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}
			if(StringUtils.isNotEmpty(param.getFechalaudohasta())){
				strSql.append(" AND ");
				strSql.append(W83bComunicacionesBD.flaudo).append("<=").append("TO_DATE(?,?)");
				params.add(param.getFechalaudohasta());
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}
		}
		//
		String desde = param.getAnyoactadesde();
		String hasta = param.getAnyoactahasta();
		String numDesde = param.getNumactadesde();
		String numHasta = param.getNumactahasta();
		if(StringUtils.isEmpty(param.getAnyoactadesde())){
			desde = "0000";
		}
		if(StringUtils.isEmpty(param.getAnyoactahasta())){
			hasta = "9999";
		}
		if(StringUtils.isEmpty(param.getNumactadesde())){
			numDesde = "000000";
		}else if(6>param.getNumactadesde().length()){
			for(int i = param.getNumactadesde().length(),size = 6;i<size;i++){
				numDesde = "0"+numDesde;//NOPMD
			}
		}
		if(StringUtils.isEmpty(param.getNumactahasta())){
			numHasta = "999999";
		}else if(6>param.getNumactahasta().length()){
			for(int i = param.getNumactahasta().length(),size = 6;i<size;i++){
				numHasta = "0"+numHasta;//NOPMD
			}
		}
		
		desde = desde + numDesde;//NOPMD
		hasta = hasta + numHasta;//NOPMD
		strSql.append(" AND ").append(W83bComunicacionesBD.nactacompleto).append(" >= ?");			
		params.add(BigDecimal.valueOf(Long.parseLong(desde)));
		strSql.append(" AND ").append(W83bComunicacionesBD.nactacompleto).append(" <= ?");
		params.add(BigDecimal.valueOf(Long.parseLong(hasta)));
		//
		List lista=W83bDataBase.executeQuery(strSql.toString(),params,W83bComunicacionesBean.class,param.getUsuarioBean(), null);	
		lista.add("extracciondatos");
		return lista;
	}
	
	
	   /**
	    * Devuelve el numero de comunicaciones de preavisos que se van a mandar a correspondencia
	    * @param comunicacionBean the param
	    * @return the java.lang.Integer
	    * @throws Exception the exception
	    */
	   public java.lang.Integer obtenerNumPreavisosGenerarComunic( w83b.w83bBeans.W83bComunicacionesBean comunicacionBean )throws Exception{
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();
			
			strSql.append("SELECT "); 
			strSql.append(" count(NUMPREAVISO) ");
			strSql.append(" FROM ").append(W83bComunicacionesBD.vistacomunicpreaviso);
			strSql.append(" WHERE ");
			if(StringUtils.isNotEmpty(comunicacionBean.getFechapreavisodesde())){
				strSql.append(W83bComunicacionesBD.fechaentrada).append(">=").append("TO_DATE(?,?)");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(comunicacionBean.getFechapreavisodesde(),comunicacionBean.getIdioma()), comunicacionBean.getIdioma()));
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(comunicacionBean.getIdioma()));
				strSql.append(" AND ");
			}
			
			strSql.append("((").append(W83bComunicacionesBD.anopreaviso).append("=").append("?");
			params.add(new Integer(comunicacionBean.getAnopreaviso()));
			strSql.append(" AND ");
			strSql.append(W83bComunicacionesBD.npre).append(">=").append("?").append(")");
			params.add(comunicacionBean.getNumpreaviso());	
			strSql.append(" OR ");
			strSql.append("(").append(W83bComunicacionesBD.anopreaviso).append(">").append("?");
			params.add(new Integer(comunicacionBean.getAnopreaviso()));
			strSql.append(" AND ");
			strSql.append(W83bComunicacionesBD.npre).append(">=").append("0").append("))");
			if(StringUtils.isNotEmpty(comunicacionBean.getTerritorio())){
				strSql.append(" AND ");
				strSql.append(W83bListadosBD.territorio).append("=").append("?");
				params.add(comunicacionBean.getTerritorio());
			}
			strSql.append(" and territ||'/'||anopreaviso||'/'||npre in(" +
					"select a1.C_TERRIT_038||'/'||a1.ANO_PREAVISO_038||'/'||a1.N_PREAVISO_038 from w83b38s00 a1 where  a1.tp_doc_038= ? "+ 
					"AND a1.F_REG_038 IN (select max(a2.F_REG_038) from W83B38T00 a2 "+ 
                     "where a2.ano_preaviso_038 = a1.ano_preaviso_038 "+ 
                     "and a2.n_preaviso_038 = a1.n_preaviso_038  "+ 
                     "and a2.c_territ_038= a1.c_territ_038 and a2.tp_doc_038= a1.tp_doc_038 ) ");
			
			params.add(comunicacionBean.getIdTipoDocumento());
			
			//Si ha marcado solo aadir pendientes
			if(comunicacionBean.getTipoComunicacionesEnviar().equals(W83bClsConstantes.ENVIO_PENDIENTES)){
				strSql.append(" and a1.ID_REMESA_ACUSE_038 is null ");
			}

			
			strSql.append(" )");
			
			
			List preavisos = W83bDataBase.executeSimpleQuery(strSql.toString(), params, comunicacionBean.getUsuarioBean());
			return Integer.valueOf(preavisos.get(0).toString());
			
	   }
	   
	   /**
	    * Devuelve los preavisos de los que se va a enviar comunicacin
	    * @param comunicacionBean the param
	    * @return java.util.List
	    * @throws Exception the exception
	    */
	   public java.util.List obtenerPreavisosGenerarComunic( w83b.w83bBeans.W83bComunicacionesBean comunicacionBean )throws Exception{
				StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
				List params = new ArrayList();
				strSql.append("SELECT "); 
				strSql.append("TO_CHAR(").append(W83bComunicacionesBD.fechaentrada).append(",?) AS ").append(W83bListadosBD.fechaEntrada).append(" , ");
				strSql.append(W83bComunicacionesBD.numpreaviso).append(", ");
				strSql.append(W83bComunicacionesBD.numpreavisoint).append(", ");
				strSql.append(W83bComunicacionesBD.razon).append(", ");
				strSql.append(W83bComunicacionesBD.domicilio).append(", ");
				strSql.append(W83bComunicacionesBD.codigopostal).append(", ");
				strSql.append(W83bComunicacionesBD.municipio).append(", ");
				strSql.append(W83bComunicacionesBD.provincia).append(", ");
				strSql.append(W83bComunicacionesBD.territ).append(", ");
				strSql.append(W83bComunicacionesBD.anopreaviso).append(", ");
				strSql.append(W83bComunicacionesBD.npre).append(", ");
				strSql.append(W83bComunicacionesBD.dirorig).append(", ");
				strSql.append(W83bComunicacionesBD.cporig).append(", ");
				strSql.append(W83bComunicacionesBD.munorig).append(", ");
				strSql.append(W83bComunicacionesBD.provorig);
			strSql.append(" FROM ").append(W83bComunicacionesBD.vistacomunicpreaviso);
			strSql.append(" WHERE ");
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(comunicacionBean.getIdioma()));
			if(StringUtils.isNotEmpty(comunicacionBean.getFechapreavisodesde())){
				strSql.append(W83bComunicacionesBD.fechaentrada).append(">=").append("TO_DATE(?,?)");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(comunicacionBean.getFechapreavisodesde(),comunicacionBean.getIdioma()), comunicacionBean.getIdioma()));
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(comunicacionBean.getIdioma()));
				strSql.append(" AND ");
			}
			
			strSql.append("((").append(W83bComunicacionesBD.anopreaviso).append("=").append("?");
			params.add(new Integer(comunicacionBean.getAnopreaviso()));
			strSql.append(" AND ");
			strSql.append(W83bComunicacionesBD.npre).append(">=").append("?").append(")");
			params.add(comunicacionBean.getNumpreaviso());	
			strSql.append(" OR ");
			strSql.append("(").append(W83bComunicacionesBD.anopreaviso).append(">").append("?");
			params.add(new Integer(comunicacionBean.getAnopreaviso()));
			strSql.append(" AND ");
			strSql.append(W83bComunicacionesBD.npre).append(">=").append("0").append("))");
			if(StringUtils.isNotEmpty(comunicacionBean.getTerritorio())){
				strSql.append(" AND ");
				strSql.append(W83bListadosBD.territorio).append("=").append("?");
				params.add(comunicacionBean.getTerritorio());
			}
			strSql.append(" and territ||'/'||anopreaviso||'/'||npre in(" +
					"select a1.C_TERRIT_038||'/'||a1.ANO_PREAVISO_038||'/'||a1.N_PREAVISO_038 from w83b38s00 a1 where  a1.tp_doc_038= ? "+ 
					"AND a1.F_REG_038 IN (select max(a2.F_REG_038) from W83B38T00 a2 "+ 
                     "where a2.ano_preaviso_038 = a1.ano_preaviso_038 "+ 
                     "and a2.n_preaviso_038 = a1.n_preaviso_038  "+ 
                     "and a2.c_territ_038= a1.c_territ_038 and a2.tp_doc_038= a1.tp_doc_038 ) ");
			
			params.add(comunicacionBean.getIdTipoDocumento());
			
			//Si ha marcado solo aadir pendientes
			if(comunicacionBean.getTipoComunicacionesEnviar().equals(W83bClsConstantes.ENVIO_PENDIENTES)){
				strSql.append(" and a1.ID_REMESA_ACUSE_038 is null ");
			}

			
			strSql.append(" )");
			
			
			List lista=W83bDataBase.executeQuery(strSql.toString(),params,W83bComunicacionesBean.class,comunicacionBean.getUsuarioBean(), null);
			lista.add("preaviso");
			return lista;
	   }
	   
	   
	   /**
	    * Devuelve el numero de comunicaciones de actas que se van a mandar a correspondencia en el caso de centros
	    * @param comunicacionBean the param
	    * @return the java.lang.Integer
	    * @throws Exception the exception
	    */
	   public java.lang.Integer obtenerNumActasGenerarComunicEmpresas( w83b.w83bBeans.W83bComunicacionesBean comunicacionBean )throws Exception{
		   StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();
			strSql.append("SELECT "); 
			strSql.append(" count(territ||'/'||anoacta||'/'||nacta) ");
			strSql.append(" FROM TABLE (");
		    strSql.append(W83bComunicacionesBD.comempresas);
		    strSql.append(")");
			strSql.append(" WHERE ");
			if(StringUtils.isNotEmpty(comunicacionBean.getFechaentradadesde())){
				strSql.append(W83bComunicacionesBD.fechaentrada).append(">=").append("TO_DATE(?,?)");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(comunicacionBean.getFechaentradadesde(),comunicacionBean.getIdioma()), comunicacionBean.getIdioma()));
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(comunicacionBean.getIdioma()));
			}
			if(StringUtils.isNotEmpty(comunicacionBean.getTerritorio())){
				strSql.append(" AND ");
				strSql.append(W83bListadosBD.territorio).append("=").append("?");
				params.add(comunicacionBean.getTerritorio());
			}
			if(StringUtils.isNotEmpty(comunicacionBean.getFechaentradahasta())){
				strSql.append(" AND ");
				strSql.append(W83bComunicacionesBD.fechaentrada).append("<=").append("TO_DATE(?,?)");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(comunicacionBean.getFechaentradahasta(),comunicacionBean.getIdioma()), comunicacionBean.getIdioma()));
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(comunicacionBean.getIdioma()));
			}
			
			
			strSql.append(" AND territ||'/'||anoacta||'/'||nacta " +
					"IN (SELECT a1.C_TERRIT_020||'/'||a1.ANO_ACTA_020||'/'||a1.N_ACTA_020 FROM w83b20s00 a1 WHERE a1.tp_doc_020 = ? " +
					"AND a1.F_REG_020  IN (SELECT MAX(a2.F_REG_020) FROM W83B20T00 a2 WHERE a2.ano_acta_020 = a1.ano_acta_020 " +
					"AND a2.n_acta_020 = a1.n_acta_020 AND a2.c_territ_020 = a1.c_territ_020 AND a2.tp_doc_020 = a1.tp_doc_020) ");
			
			params.add(comunicacionBean.getIdTipoDocumento());
			
			//Si ha marcado solo aadir pendientes
			if(comunicacionBean.getTipoComunicacionesEnviar().equals(W83bClsConstantes.ENVIO_PENDIENTES)){
				strSql.append(" and a1.ID_REMESA_ACUSE_020 is null ");
			}

			
			strSql.append(" )");
			
			
			List actas = W83bDataBase.executeSimpleQuery(strSql.toString(), params, comunicacionBean.getUsuarioBean());
			return Integer.valueOf(actas.get(0).toString());
			
	   }
	   
	   

	   
	   
	   /**
	    * Devuelve el numero de comunicaciones de actas que se van a mandar a correspondencia en el caso de empresas fiscales
	    * @param param the param
	    * @return the java.lang.Integer
	    * @throws Exception the exception
	    */
	   public java.lang.Integer obtenerNumActasGenerarComunicEmpresasFiscal( w83b.w83bBeans.W83bComunicacionesBean comunicacionBean )throws Exception{
		   StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();
			strSql.append("SELECT "); 
			strSql.append(" count(territ||'/'||anoacta||'/'||nacta) ");
			strSql.append(" FROM TABLE (");
		    strSql.append(W83bComunicacionesBD.comempresasfiscal);
		    strSql.append(")");
			strSql.append(" WHERE ");
			if(StringUtils.isNotEmpty(comunicacionBean.getFechaentradadesde())){
				strSql.append(W83bComunicacionesBD.fechaentrada).append(">=").append("TO_DATE(?,?)");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(comunicacionBean.getFechaentradadesde(),comunicacionBean.getIdioma()), comunicacionBean.getIdioma()));
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(comunicacionBean.getIdioma()));
			}
			if(StringUtils.isNotEmpty(comunicacionBean.getFechaentradahasta())){
				strSql.append(" AND ");
				strSql.append(W83bComunicacionesBD.fechaentrada).append("<=").append("TO_DATE(?,?)");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(comunicacionBean.getFechaentradahasta(),comunicacionBean.getIdioma()), comunicacionBean.getIdioma()));
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(comunicacionBean.getIdioma()));
			}
			if(StringUtils.isNotEmpty(comunicacionBean.getTerritorio())){
				strSql.append(" AND ");
				strSql.append(W83bListadosBD.territorio).append("=").append("?");
				params.add(comunicacionBean.getTerritorio());
			}
			
			
			strSql.append(" AND territ||'/'||anoacta||'/'||nacta " +
					"IN (SELECT a1.C_TERRIT_020||'/'||a1.ANO_ACTA_020||'/'||a1.N_ACTA_020 FROM w83b20s00 a1 WHERE a1.tp_doc_020 = ? " +
					"AND a1.F_REG_020  IN (SELECT MAX(a2.F_REG_020) FROM W83B20T00 a2 WHERE a2.ano_acta_020 = a1.ano_acta_020 " +
					"AND a2.n_acta_020 = a1.n_acta_020 AND a2.c_territ_020 = a1.c_territ_020 AND a2.tp_doc_020 = a1.tp_doc_020) ");
			
			params.add(comunicacionBean.getIdTipoDocumento());
			
			//Si ha marcado solo aadir pendientes
			if(comunicacionBean.getTipoComunicacionesEnviar().equals(W83bClsConstantes.ENVIO_PENDIENTES)){
				strSql.append(" and a1.ID_REMESA_ACUSE_020 is null ");
			}

			
			strSql.append(" )");
			
			List actas = W83bDataBase.executeSimpleQuery(strSql.toString(), params, comunicacionBean.getUsuarioBean());
			return Integer.valueOf(actas.get(0).toString());
	   }
	   
	   /**
	    * Devuelve las actas  de empresas fiscales de los que se va a enviar comunicacin
	    * @param comunicacionBean the param
	    * @return java.util.List
	    * @throws Exception the exception
	    */
	   public java.util.List obtenerActasGenerarComunicEmpresasFiscal( w83b.w83bBeans.W83bComunicacionesBean param )throws Exception{
			
		   StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();
			strSql.append("SELECT "); 
			strSql.append("TO_CHAR(").append(W83bComunicacionesBD.fechaentrada).append(",?) AS ").append(W83bListadosBD.fechaEntrada).append(" , ");
			strSql.append(W83bComunicacionesBD.territ).append(", ");
			strSql.append(W83bComunicacionesBD.razon).append(", ");
			strSql.append(W83bComunicacionesBD.domicilio).append(", ");
			strSql.append(W83bComunicacionesBD.codigopostal).append(", ");
			strSql.append(W83bComunicacionesBD.municipio).append(", ");
			strSql.append(W83bComunicacionesBD.provincia).append(", ");
			strSql.append(W83bComunicacionesBD.nacta).append(", ");
			strSql.append(W83bComunicacionesBD.anoacta).append(", ");
			strSql.append(W83bComunicacionesBD.dirorig).append(", ");
			strSql.append(W83bComunicacionesBD.cporig).append(", ");
			strSql.append(W83bComunicacionesBD.munorig).append(", ");
			strSql.append(W83bComunicacionesBD.provorig);
			strSql.append(" FROM TABLE (");
		    strSql.append(W83bComunicacionesBD.comempresasfiscal);
		    strSql.append(")");
			strSql.append(" WHERE ");
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			if(StringUtils.isNotEmpty(param.getFechaentradadesde())){
				strSql.append(W83bComunicacionesBD.fechaentrada).append(">=").append("TO_DATE(?,?)");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaentradadesde(),param.getIdioma()), param.getIdioma()));
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}
			if(StringUtils.isNotEmpty(param.getFechaentradahasta())){
				strSql.append(" AND ");
				strSql.append(W83bComunicacionesBD.fechaentrada).append("<=").append("TO_DATE(?,?)");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaentradahasta(),param.getIdioma()), param.getIdioma()));
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}
			if(StringUtils.isNotEmpty(param.getTerritorio())){
				strSql.append(" AND ");
				strSql.append(W83bListadosBD.territorio).append("=").append("?");
				params.add(param.getTerritorio());
			}
			
			strSql.append(" AND territ||'/'||anoacta||'/'||nacta " +
					"IN (SELECT a1.C_TERRIT_020||'/'||a1.ANO_ACTA_020||'/'||a1.N_ACTA_020 FROM w83b20s00 a1 WHERE a1.tp_doc_020 = ? " +
					"AND a1.F_REG_020  IN (SELECT MAX(a2.F_REG_020) FROM W83B20T00 a2 WHERE a2.ano_acta_020 = a1.ano_acta_020 " +
					"AND a2.n_acta_020 = a1.n_acta_020 AND a2.c_territ_020 = a1.c_territ_020 AND a2.tp_doc_020 = a1.tp_doc_020) ");
			
			params.add(param.getIdTipoDocumento());
			
			//Si ha marcado solo aadir pendientes
			if(param.getTipoComunicacionesEnviar().equals(W83bClsConstantes.ENVIO_PENDIENTES)){
				strSql.append(" and a1.ID_REMESA_ACUSE_020 is null ");
			}
			
			strSql.append(" )");
			
			List lista=W83bDataBase.executeQuery(strSql.toString(),params,W83bComunicacionesBean.class,param.getUsuarioBean(), null);
			lista.add("comempresas");	
			return lista;
	   }
	   
	   
	   /**
	    * Devuelve las actas  de centros de los que se va a enviar comunicacin
	    * @param comunicacionBean the param
	    * @return the java.lang.Integer
	    * @throws Exception the exception
	    */
	   public java.util.List obtenerActasGenerarComunicEmpresas( w83b.w83bBeans.W83bComunicacionesBean param )throws Exception{
			
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();
			strSql.append("SELECT "); 
			strSql.append("TO_CHAR(").append(W83bComunicacionesBD.fechaentrada).append(",?) AS ").append(W83bListadosBD.fechaEntrada).append(" , ");
			strSql.append(W83bComunicacionesBD.territ).append(", ");
			strSql.append(W83bComunicacionesBD.razon).append(", ");
			strSql.append(W83bComunicacionesBD.domicilio).append(", ");
			strSql.append(W83bComunicacionesBD.codigopostal).append(", ");
			strSql.append(W83bComunicacionesBD.municipio).append(", ");
			strSql.append(W83bComunicacionesBD.provincia).append(", ");
			strSql.append(W83bComunicacionesBD.nacta).append(", ");
			strSql.append(W83bComunicacionesBD.anoacta).append(", ");
			strSql.append(W83bComunicacionesBD.dirorig).append(", ");
			strSql.append(W83bComunicacionesBD.cporig).append(", ");
			strSql.append(W83bComunicacionesBD.munorig).append(", ");
			strSql.append(W83bComunicacionesBD.provorig);
			strSql.append(" FROM TABLE (");
		    strSql.append(W83bComunicacionesBD.comempresas);
		    strSql.append(")");
			strSql.append(" WHERE ");
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			if(StringUtils.isNotEmpty(param.getFechaentradadesde())){
				strSql.append(W83bComunicacionesBD.fechaentrada).append(">=").append("TO_DATE(?,?)");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaentradadesde(),param.getIdioma()), param.getIdioma()));
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}
			if(StringUtils.isNotEmpty(param.getTerritorio())){
				strSql.append(" AND ");
				strSql.append(W83bListadosBD.territorio).append("=").append("?");
				params.add(param.getTerritorio());
			}
			if(StringUtils.isNotEmpty(param.getFechaentradahasta())){
				strSql.append(" AND ");
				strSql.append(W83bComunicacionesBD.fechaentrada).append("<=").append("TO_DATE(?,?)");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaentradahasta(),param.getIdioma()), param.getIdioma()));
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}
			
			strSql.append(" AND territ||'/'||anoacta||'/'||nacta " +
					"IN (SELECT a1.C_TERRIT_020||'/'||a1.ANO_ACTA_020||'/'||a1.N_ACTA_020 FROM w83b20s00 a1 WHERE a1.tp_doc_020 = ? " +
					"AND a1.F_REG_020  IN (SELECT MAX(a2.F_REG_020) FROM W83B20T00 a2 WHERE a2.ano_acta_020 = a1.ano_acta_020 " +
					"AND a2.n_acta_020 = a1.n_acta_020 AND a2.c_territ_020 = a1.c_territ_020 AND a2.tp_doc_020 = a1.tp_doc_020) ");
			
			params.add(param.getIdTipoDocumento());
			
			//Si ha marcado solo aadir pendientes
			if(param.getTipoComunicacionesEnviar().equals(W83bClsConstantes.ENVIO_PENDIENTES)){
				strSql.append(" and a1.ID_REMESA_ACUSE_020 is null ");
			}
			
			strSql.append(" )");
			
			List lista=W83bDataBase.executeQuery(strSql.toString(),params,W83bComunicacionesBean.class,param.getUsuarioBean(), null);
			lista.add("comempresas");	
			return lista;
	   }
	   
	   
	   /**
	    * Devuelve el numero de comunicaciones de actas que se van a mandar a correspondencia de requerimientos de mesa
	    * @param comunicacionBean the param
	    * @return the java.lang.Integer
	    * @throws Exception the exception
	    */
	   public java.lang.Integer obtenerNumActasGenerarComunicRequMesa(w83b.w83bBeans.W83bComunicacionesBean comunicacionBean) throws Exception{
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();
			strSql.append("SELECT "); 
			strSql.append(" count(territ||'/'||anoacta||'/'||nacta) ");
			strSql.append(" FROM ").append(W83bComunicacionesBD.comrequemesa);
			strSql.append(" WHERE ");
			if(StringUtils.isNotEmpty(comunicacionBean.getFechaentradadesde())){
				strSql.append(W83bComunicacionesBD.fechaentrada).append(">=").append("TO_DATE(?,?)");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(comunicacionBean.getFechaentradadesde(),comunicacionBean.getIdioma()), comunicacionBean.getIdioma()));
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(comunicacionBean.getIdioma()));
			}
			
			if(StringUtils.isNotEmpty(comunicacionBean.getFechaentradahasta())){
				strSql.append(" AND ");
				strSql.append(W83bComunicacionesBD.fechaentrada).append("<=").append("TO_DATE(?,?)");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(comunicacionBean.getFechaentradahasta(),comunicacionBean.getIdioma()), comunicacionBean.getIdioma()));
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(comunicacionBean.getIdioma()));
			}

			if(StringUtils.isNotEmpty(comunicacionBean.getTerritorio())){
				strSql.append(" AND ");
				strSql.append(W83bListadosBD.territorio).append("=").append("?");
				params.add(comunicacionBean.getTerritorio());
			}
			if(StringUtils.isNotEmpty(comunicacionBean.getNumactadesde())){
				strSql.append(" AND ((");
				strSql.append(W83bComunicacionesBD.anoacta).append("=").append("? ");
				strSql.append(" AND ");
				strSql.append(W83bComunicacionesBD.nacta).append(">=").append("? ");
				strSql.append(") OR (");
				strSql.append(W83bComunicacionesBD.anoacta).append(">").append("? ");
				strSql.append(" AND ");
				strSql.append(W83bComunicacionesBD.nacta).append(">=0))");
				params.add(comunicacionBean.getAnyoactadesde());
				params.add(comunicacionBean.getNumactadesde());
				params.add(comunicacionBean.getAnyoactadesde());
			}
			if(StringUtils.isNotEmpty(comunicacionBean.getNumactahasta())){
				strSql.append(" AND ((");
				strSql.append(W83bComunicacionesBD.anoacta).append("=").append("? ");
				strSql.append(" AND ");
				strSql.append(W83bComunicacionesBD.nacta).append("<=").append("? ");
				strSql.append(") OR (");
				strSql.append(W83bComunicacionesBD.anoacta).append("<").append("? ");
				strSql.append(" AND ");
				strSql.append(W83bComunicacionesBD.nacta).append(">=0))");
				params.add(comunicacionBean.getAnyoactahasta());
				params.add(comunicacionBean.getNumactahasta());
				params.add(comunicacionBean.getAnyoactahasta());
			}
			
			strSql.append(" AND territ||'/'||anoacta||'/'||nacta " +
					"IN (SELECT a1.C_TERRIT_020||'/'||a1.ANO_ACTA_020||'/'||a1.N_ACTA_020 FROM w83b20s00 a1 WHERE a1.tp_doc_020 = ? " +
					"AND a1.F_REG_020  IN (SELECT MAX(a2.F_REG_020) FROM W83B20T00 a2 WHERE a2.ano_acta_020 = a1.ano_acta_020 " +
					"AND a2.n_acta_020 = a1.n_acta_020 AND a2.c_territ_020 = a1.c_territ_020 AND a2.tp_doc_020 = a1.tp_doc_020) ");
			
			params.add(comunicacionBean.getIdTipoDocumento());
			
			//Si ha marcado solo aadir pendientes
			if(comunicacionBean.getTipoComunicacionesEnviar().equals(W83bClsConstantes.ENVIO_PENDIENTES)){
				strSql.append(" and a1.ID_REMESA_ACUSE_020 is null ");
			}

			
			strSql.append(" )");
			
			
			List actas = W83bDataBase.executeSimpleQuery(strSql.toString(), params, comunicacionBean.getUsuarioBean());
			return Integer.valueOf(actas.get(0).toString());
		}
	   
	   
	   /**
	    * Devuelve los actas de los que se va a enviar comunicacin de requerimientos de mesa
	    * @param comunicacionBean the param
	    * @return java.util.List
	    * @throws Exception the exception
	    */
		public java.util.List obtenerActasGenerarComunicRequMesa(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();
			strSql.append("SELECT "); 
			strSql.append("TO_CHAR(").append(W83bComunicacionesBD.fechaentrada).append(",?) AS ").append(W83bListadosBD.fechaEntrada).append(" , ");
			strSql.append(W83bComunicacionesBD.territ).append(", ");
			strSql.append(W83bComunicacionesBD.razon).append(", ");
			strSql.append(W83bComunicacionesBD.domicilio).append(", ");
			strSql.append(W83bComunicacionesBD.codigopostal).append(", ");
			strSql.append(W83bComunicacionesBD.municipio).append(", ");
			strSql.append(W83bComunicacionesBD.provincia).append(", ");
			strSql.append(W83bComunicacionesBD.nacta).append(", ");
			strSql.append(W83bComunicacionesBD.anoacta).append(", ");
			strSql.append(W83bComunicacionesBD.dirorig).append(", ");
			strSql.append(W83bComunicacionesBD.cporig).append(", ");
			strSql.append(W83bComunicacionesBD.munorig).append(", ");
			strSql.append(W83bComunicacionesBD.provorig);
			strSql.append(" FROM ").append(W83bComunicacionesBD.comrequemesa);
			strSql.append(" WHERE ");
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			if(StringUtils.isNotEmpty(param.getFechaentradadesde())){
				strSql.append(W83bComunicacionesBD.fechaentrada).append(">=").append("TO_DATE(?,?)");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaentradadesde(),param.getIdioma()), param.getIdioma()));
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}
			
			if(StringUtils.isNotEmpty(param.getFechaentradahasta())){
				strSql.append(" AND ");
				strSql.append(W83bComunicacionesBD.fechaentrada).append("<=").append("TO_DATE(?,?)");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaentradahasta(),param.getIdioma()), param.getIdioma()));
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}

			if(StringUtils.isNotEmpty(param.getTerritorio())){
				strSql.append(" AND ");
				strSql.append(W83bListadosBD.territorio).append("=").append("?");
				params.add(param.getTerritorio());
			}
			if(StringUtils.isNotEmpty(param.getNumactadesde())){
				strSql.append(" AND ((");
				strSql.append(W83bComunicacionesBD.anoacta).append("=").append("? ");
				strSql.append(" AND ");
				strSql.append(W83bComunicacionesBD.nacta).append(">=").append("? ");
				strSql.append(") OR (");
				strSql.append(W83bComunicacionesBD.anoacta).append(">").append("? ");
				strSql.append(" AND ");
				strSql.append(W83bComunicacionesBD.nacta).append(">=0))");
				params.add(param.getAnyoactadesde());
				params.add(param.getNumactadesde());
				params.add(param.getAnyoactadesde());
			}
			if(StringUtils.isNotEmpty(param.getNumactahasta())){
				strSql.append(" AND ((");
				strSql.append(W83bComunicacionesBD.anoacta).append("=").append("? ");
				strSql.append(" AND ");
				strSql.append(W83bComunicacionesBD.nacta).append("<=").append("? ");
				strSql.append(") OR (");
				strSql.append(W83bComunicacionesBD.anoacta).append("<").append("? ");
				strSql.append(" AND ");
				strSql.append(W83bComunicacionesBD.nacta).append(">=0))");
				params.add(param.getAnyoactahasta());
				params.add(param.getNumactahasta());
				params.add(param.getAnyoactahasta());
			}
			
			strSql.append(" AND territ||'/'||anoacta||'/'||nacta " +
					"IN (SELECT a1.C_TERRIT_020||'/'||a1.ANO_ACTA_020||'/'||a1.N_ACTA_020 FROM w83b20s00 a1 WHERE a1.tp_doc_020 = ? " +
					"AND a1.F_REG_020  IN (SELECT MAX(a2.F_REG_020) FROM W83B20T00 a2 WHERE a2.ano_acta_020 = a1.ano_acta_020 " +
					"AND a2.n_acta_020 = a1.n_acta_020 AND a2.c_territ_020 = a1.c_territ_020 AND a2.tp_doc_020 = a1.tp_doc_020) ");
			
			params.add(param.getIdTipoDocumento());
			
			//Si ha marcado solo aadir pendientes
			if(param.getTipoComunicacionesEnviar().equals(W83bClsConstantes.ENVIO_PENDIENTES)){
				strSql.append(" and a1.ID_REMESA_ACUSE_020 is null ");
			}

			
			strSql.append(" )");
			
			
			List lista=W83bDataBase.executeQuery(strSql.toString(),params,W83bComunicacionesBean.class,param.getUsuarioBean(), null);
			lista.add("requemesa");	
			return lista;
		}
		
		/**
	    * Devuelve el numero de comunicaciones de incidencias que se van a mandar a correspondencia
	    * @param param the param
	    * @return the java.lang.Integer
	    * @throws Exception the exception
	    */
		 public java.lang.Integer obtenerNumIncidenciasGenerarComunic(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();
			strSql.append("SELECT "); 
			strSql.append(" count(territ||'/'||anoincidencia||'/'||numincidencia) ");
			strSql.append(" FROM ");
		    strSql.append(W83bComunicacionesBD.comincidencias);
		    strSql.append(" WHERE ");
		    strSql.append(W83bComunicacionesBD.fechavalidacion).append(">=TO_DATE(?,?)");
		    strSql.append(" AND ");
		    strSql.append(W83bComunicacionesBD.fechavalidacion).append("<=TO_DATE(?,?)");
		    strSql.append(" AND ");
		    params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechavalidaciondesde(),param.getIdioma()), param.getIdioma()));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechavalidacionhasta(),param.getIdioma()), param.getIdioma()));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		    params.add(param.getTerritorio());
		    strSql.append(W83bComunicacionesBD.territ).append("=?");   
		    if (StringUtils.isNotEmpty(param.getCentroTrabajo().getNumCentro())){
		    	strSql.append(" AND ");
			    strSql.append(W83bComunicacionesBD.numcentro).append("=?");
			    params.add(param.getCentroTrabajo().getNumCentro());
		    }
		    
		    String desde = param.getAnyoactadesde();
			String hasta = param.getAnyoactahasta();
			String numDesde = param.getNumactadesde();
			String numHasta = param.getNumactahasta();
			if(StringUtils.isEmpty(param.getAnyoactadesde())){
				desde = "0000";
			}
			if(StringUtils.isEmpty(param.getAnyoactahasta())){
				hasta = "9999";
			}
			if(StringUtils.isEmpty(param.getNumactadesde())){
				numDesde = "000000";
			}else if(6>param.getNumactadesde().length()){
				for(int i = param.getNumactadesde().length(),size = 6;i<size;i++){
					numDesde = "0"+numDesde;//NOPMD
				}
			}
			if(StringUtils.isEmpty(param.getNumactahasta())){
				numHasta = "999999";
			}else if(6>param.getNumactahasta().length()){
				for(int i = param.getNumactahasta().length(),size = 6;i<size;i++){
					numHasta = "0"+numHasta;//NOPMD
				}
			}
			desde = desde + numDesde;//NOPMD
			hasta = hasta + numHasta;//NOPMD
			strSql.append(" AND SUBSTR(").append(W83bComunicacionesBD.numaactaint);
			strSql.append(" ,length(").append(W83bComunicacionesBD.numaactaint).append(")-9,10) >= ?");			
			params.add(BigDecimal.valueOf(Long.parseLong(desde)));
			strSql.append(" AND SUBSTR(").append(W83bComunicacionesBD.numaactaint);
			strSql.append(" ,length(").append(W83bComunicacionesBD.numaactaint).append(")-9,10) <= ? ");	
			params.add(BigDecimal.valueOf(Long.parseLong(hasta)));
			
			
			strSql.append("AND territ||'/'||anoincidencia||'/'||numincidencia ");
			strSql.append("IN (SELECT a1.C_TERRIT_064||'/'||a1.ANO_INCID_064||'/'||a1.N_INCID_064 FROM w83b64s00 a1 WHERE a1.tp_doc_064 = ? ");
			strSql.append("AND a1.F_REG_064  IN (SELECT MAX(a2.F_REG_064) FROM W83B64T00 a2 WHERE a2.ANO_INCID_064 = a1.ANO_INCID_064 ");
			strSql.append("AND a2.N_INCID_064 = a1.N_INCID_064 AND a2.c_territ_064 = a1.c_territ_064 AND a2.tp_doc_064 = a1.tp_doc_064) ");
		    
			params.add(param.getIdTipoDocumento());
			
			//Si ha marcado solo aadir pendientes
			if(param.getTipoComunicacionesEnviar().equals(W83bClsConstantes.ENVIO_PENDIENTES)){
				strSql.append(" and a1.ID_REMESA_ACUSE_064 is null ");
			}

			
			strSql.append(" )");
			
		    
			List actas = W83bDataBase.executeSimpleQuery(strSql.toString(), params, param.getUsuarioBean());
			return Integer.valueOf(actas.get(0).toString());
		}
		 
		 
	   /**
	    * Devuelve las incidencias de los que se va a enviar comunicacin
	    * @param comunicacionBean the param
	    * @return java.util.List
	    * @throws Exception the exception
	    */
		public java.util.List obtenerIncidenciasGenerarComunic(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();
			strSql.append("SELECT ");
			strSql.append(W83bComunicacionesBD.nacta).append(", ");
			strSql.append(W83bComunicacionesBD.anoacta).append(", ");
			strSql.append(W83bComunicacionesBD.territ).append(", ");
			strSql.append(W83bComunicacionesBD.razon).append(", ");
			strSql.append(W83bComunicacionesBD.domicilio).append(", ");
			strSql.append(W83bComunicacionesBD.municipio).append(", ");
			strSql.append(W83bComunicacionesBD.provincia).append(", ");
			strSql.append(W83bComunicacionesBD.codigopostal).append(", ");
			strSql.append(W83bComunicacionesBD.cporig).append(", ");
			strSql.append(W83bComunicacionesBD.munorig).append(", ");
			strSql.append(W83bComunicacionesBD.provorig).append(", ");
			strSql.append(W83bComunicacionesBD.numincidencia).append(", ");
			strSql.append(W83bComunicacionesBD.anoincidencia);
			strSql.append(" FROM ");
		    strSql.append(W83bComunicacionesBD.comincidencias);
		    strSql.append(" WHERE ");
		    strSql.append(W83bComunicacionesBD.fechavalidacion).append(">=TO_DATE(?,?)");
		    strSql.append(" AND ");
		    strSql.append(W83bComunicacionesBD.fechavalidacion).append("<=TO_DATE(?,?)");
		    strSql.append(" AND ");
		    params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechavalidaciondesde(),param.getIdioma()), param.getIdioma()));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechavalidacionhasta(),param.getIdioma()), param.getIdioma()));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		    params.add(param.getTerritorio());
		    strSql.append(W83bComunicacionesBD.territ).append("=?");   
		    if (StringUtils.isNotEmpty(param.getCentroTrabajo().getNumCentro())){
		    	strSql.append(" AND ");
			    strSql.append(W83bComunicacionesBD.numcentro).append("=?");
			    params.add(param.getCentroTrabajo().getNumCentro());
		    }
		    
		    String desde = param.getAnyoactadesde();
			String hasta = param.getAnyoactahasta();
			String numDesde = param.getNumactadesde();
			String numHasta = param.getNumactahasta();
			if(StringUtils.isEmpty(param.getAnyoactadesde())){
				desde = "0000";
			}
			if(StringUtils.isEmpty(param.getAnyoactahasta())){
				hasta = "9999";
			}
			if(StringUtils.isEmpty(param.getNumactadesde())){
				numDesde = "000000";
			}else if(6>param.getNumactadesde().length()){
				for(int i = param.getNumactadesde().length(),size = 6;i<size;i++){
					numDesde = "0"+numDesde;//NOPMD
				}
			}
			if(StringUtils.isEmpty(param.getNumactahasta())){
				numHasta = "999999";
			}else if(6>param.getNumactahasta().length()){
				for(int i = param.getNumactahasta().length(),size = 6;i<size;i++){
					numHasta = "0"+numHasta;//NOPMD
				}
			}
			desde = desde + numDesde;//NOPMD
			hasta = hasta + numHasta;//NOPMD
			strSql.append(" AND SUBSTR(").append(W83bComunicacionesBD.numaactaint);
			strSql.append(" ,length(").append(W83bComunicacionesBD.numaactaint).append(")-9,10) >= ?");			
			params.add(BigDecimal.valueOf(Long.parseLong(desde)));
			strSql.append(" AND SUBSTR(").append(W83bComunicacionesBD.numaactaint);
			strSql.append(" ,length(").append(W83bComunicacionesBD.numaactaint).append(")-9,10) <= ? ");	
			params.add(BigDecimal.valueOf(Long.parseLong(hasta)));
			
			
			strSql.append("AND territ||'/'||anoincidencia||'/'||numincidencia ");
			strSql.append("IN (SELECT a1.C_TERRIT_064||'/'||a1.ANO_INCID_064||'/'||a1.N_INCID_064 FROM w83b64s00 a1 WHERE a1.tp_doc_064 = ? ");
			strSql.append("AND a1.F_REG_064  IN (SELECT MAX(a2.F_REG_064) FROM w83b64s00 a2 WHERE a2.ANO_INCID_064 = a1.ANO_INCID_064 ");
			strSql.append("AND a2.N_INCID_064 = a1.N_INCID_064 AND a2.c_territ_064 = a1.c_territ_064 AND a2.tp_doc_064 = a1.tp_doc_064) ");
		    
			params.add(param.getIdTipoDocumento());
			
			//Si ha marcado solo aadir pendientes
			if(param.getTipoComunicacionesEnviar().equals(W83bClsConstantes.ENVIO_PENDIENTES)){
				strSql.append(" and a1.ID_REMESA_ACUSE_064 is null ");
			}

			
			strSql.append(" )");
		    
			List lista=W83bDataBase.executeQuery(strSql.toString(),params,W83bComunicacionesBean.class,param.getUsuarioBean(), null);
			lista.add("comincidencias");
			return lista; 
		}
		
		
		
	   
   /**
    * Devuelve las camunicaciones de impugnacion resuelta
    * @param comunicacionBean the param
    * @return java.util.List
    * @throws Exception the exception
    */
	public java.util.List obtenerComunicacionesImpugnaciones(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append("a1.n_impug_041||'|'||a1.ano_impug_041 as ID");
		strSql.append(" FROM W83B41T00 a1 ");
		strSql.append(" WHERE a1.tp_doc_041 = ? ");
		params.add(param.getIdTipoDocumento());
		strSql.append("AND a1.F_REG_041  IN (SELECT MAX(a2.F_REG_041) FROM W83B41T00 a2 WHERE a2.ano_impug_041 = a1.ano_impug_041 ");
		strSql.append("AND a2.n_impug_041 = a1.n_impug_041 AND a2.c_territ_041 = a1.c_territ_041 AND a2.tp_doc_041 = a1.tp_doc_041) ");
		
		//Si ha marcado solo aadir pendientes
		if(param.getTipoComunicacionesEnviar().equals(W83bClsConstantes.ENVIO_PENDIENTES)){
			strSql.append(" and a1.ID_REMESA_ACUSE_041 is null ");
		}
		
		
		List resul =  new ArrayList();
		
		List lista = W83bDataBase.executeQuery(strSql.toString(), params, null);
		
		if(lista.size()>0){
			for (Iterator iter = lista.iterator(); iter.hasNext();) {
				resul.add((String)((HashMap)iter.next()).get("ID"));
				
			}
		}
		return resul;
	}
	
	   /**
	    * Devuelve las camunicaciones de impugnacion resuelta
	    * @param comunicacionBean the param
	    * @return java.util.List
	    * @throws Exception the exception
	    */
		public java.util.List obtenerComunicacionesIncidencias(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();
			


			strSql.append("SELECT a1.C_TERRIT_064||'|'||a1.ANO_INCID_064||'|'||a1.N_INCID_064 as ID FROM w83b64s00 a1 WHERE a1.tp_doc_064 = ? ");
			strSql.append("AND a1.F_REG_064  IN (SELECT MAX(a2.F_REG_064) FROM w83b64s00 a2 WHERE a2.ANO_INCID_064 = a1.ANO_INCID_064 ");
			strSql.append("AND a2.N_INCID_064 = a1.N_INCID_064 AND a2.c_territ_064 = a1.c_territ_064 AND a2.tp_doc_064 = a1.tp_doc_064) ");
		    
			params.add(param.getIdTipoDocumento());
			
			//Si ha marcado solo aadir pendientes
			if(param.getTipoComunicacionesEnviar().equals(W83bClsConstantes.ENVIO_PENDIENTES)){
				strSql.append(" and a1.ID_REMESA_ACUSE_064 is null ");
			}
			
			
			List resul =  new ArrayList();
			
			List lista = W83bDataBase.executeQuery(strSql.toString(), params, null);
			
			if(lista.size()>0){
				for (Iterator iter = lista.iterator(); iter.hasNext();) {
					resul.add((String)((HashMap)iter.next()).get("ID"));
					
				}
			}
			return resul;
		}
		  
	   /**
	    * Devuelve las camunicaciones de preavisos
	    * @param comunicacionBean the param
	    * @return java.util.List
	    * @throws Exception the exception
	    */
		public java.util.List obtenerComunicacionesPreavisos(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();
			

			strSql.append("select a1.C_TERRIT_038||'|'||a1.ANO_PREAVISO_038||'|'||a1.N_PREAVISO_038 as ID from w83b38s00 a1 where  a1.tp_doc_038= ? "+ 
					"AND a1.F_REG_038 IN (select max(a2.F_REG_038) from W83B38T00 a2 where a2.ano_preaviso_038 = a1.ano_preaviso_038 "+ 
	                "and a2.n_preaviso_038 = a1.n_preaviso_038 and a2.c_territ_038= a1.c_territ_038 and a2.tp_doc_038= a1.tp_doc_038 ) ");
		    
			params.add(param.getIdTipoDocumento());
			

			
			//Si ha marcado solo aadir pendientes
			if(param.getTipoComunicacionesEnviar().equals(W83bClsConstantes.ENVIO_PENDIENTES)){
				strSql.append(" and a1.ID_REMESA_ACUSE_038 is null ");
			}
			
			List resul =  new ArrayList();
			
			List lista = W83bDataBase.executeQuery(strSql.toString(), params, null);
			
			if(lista.size()>0){
				for (Iterator iter = lista.iterator(); iter.hasNext();) {
					resul.add((String)((HashMap)iter.next()).get("ID"));
					
				}
			}
			return resul;
		}
		
	   /**
	    * Devuelve las camunicaciones de actas
	    * @param comunicacionBean the param
	    * @return java.util.List
	    * @throws Exception the exception
	    */
		public java.util.List obtenerComunicacionesActas(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();
			

			strSql.append("SELECT a1.C_TERRIT_020||'|'||a1.ANO_ACTA_020||'|'||a1.N_ACTA_020 as ID FROM w83b20s00 a1 WHERE a1.tp_doc_020 = ? " +
					"AND a1.F_REG_020  IN (SELECT MAX(a2.F_REG_020) FROM W83B20T00 a2 WHERE a2.ano_acta_020 = a1.ano_acta_020 " +
					"AND a2.n_acta_020 = a1.n_acta_020 AND a2.c_territ_020 = a1.c_territ_020 AND a2.tp_doc_020 = a1.tp_doc_020) ");
		    
			params.add(param.getIdTipoDocumento());
			

			
			//Si ha marcado solo aadir pendientes
			if(param.getTipoComunicacionesEnviar().equals(W83bClsConstantes.ENVIO_PENDIENTES)){
				strSql.append(" and a1.ID_REMESA_ACUSE_020 is null ");
			}
			
			List resul =  new ArrayList();
			
			List lista = W83bDataBase.executeQuery(strSql.toString(), params, null);
			
			if(lista.size()>0){
				for (Iterator iter = lista.iterator(); iter.hasNext();) {
					resul.add((String)((HashMap)iter.next()).get("ID"));
					
				}
			}
			return resul;
		}
		
				

		

}